/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _OSM_DB_H
#define _OSM_DB_H

#include <glib.h>
#include "osm.h"

/** Generic search item list indexes */
typedef enum {
	ITEM_ID,
	ITEM_CATID,
	ITEM_LAT,
	ITEM_LON,
	ITEM_DIST,
	ITEM_LATLON,
	ITEM_LABEL,
	ITEM_DESC,
	ITEM_CATLAB,
	ITEM_ICON,
	ITEM_COLOR,
	ITEM_NUM_COLUMNS
} item_list_id;

typedef enum {
        OSM_NODE_NEXT,
        OSM_NODE_PREV,
} osm_node_direction;

gboolean osm_init(sqlite3 **db);
void osm_deinit(void);

gboolean osm_db_create(sqlite3 *db);

GSList *osm_get_route_node(guint nid, osm_node_direction d);

void osm_set_way_range_from_speed(gfloat speed);
void osm_set_way_range(guint sr);

GtkListStore *osm_search_store_new(void);

gboolean osm_way_search(gdouble lat, gdouble lon, gchar *text, GtkListStore **store);

void osm_db_enable_mainloop(sqlite3 *db, gboolean eml);
void osm_progress_set_widget(sqlite3 *db, GtkProgressBar *w);
gboolean osm_db_prepare(sqlite3 *db);

gboolean osm_way_search(gdouble lat, gdouble lon, gchar *text, GtkListStore **store);

gboolean osm_way_get_nodes(osm_way *w);

gboolean osm_way_get_name(osm_way *w);
gboolean osm_way_get_name_nls(osm_way *w);

gboolean osm_way_get_ref(osm_way *w);
gboolean osm_way_get_int_ref(osm_way *w);

osm_way *osm_find_nearest_way(gint lat, gint lon);
gboolean osm_way_distance(gint lat, gint lon, osm_way_node *f, osm_way_node *t, gdouble *d);

gboolean osm_place_search(gdouble lat, gdouble lon, gchar *text, GtkListStore **store);
gboolean osm_place_get(guint32 id, gdouble lat, gdouble lon, osm_place **nr);

void osm_get_location_place_data(osm_location *map_loc);

gboolean osm_check_location(osm_location *map_loc, gint lat, gint lon);
gboolean osm_get_location_data(gint lat, gint lon, gfloat heading, osm_location *map_loc);

osm_way_node *osm_way_node_new(guint id, gint lat, gint lon, gint flags);

void osm_way_node_free(osm_way_node *n);
void osm_way_free(osm_way *w);
void osm_way_nodes_free(osm_way *w);

#endif
