#!/bin/sh
export G_SLICE=always-malloc
export G_DEBUG=gc-friendly

case "$1" in
	valgrind)
		libtool --mode=execute valgrind --tool=memcheck --leak-check=full --leak-resolution=high --num-callers=20 mapper
	;;
	massif)
		libtool --mode=execute valgrind --tool=massif --depth=5 --alloc-fn=g_malloc --alloc-fn=g_realloc --alloc-fn=g_try_malloc \
         --alloc-fn=g_malloc0 --alloc-fn=g_mem_chunk_alloc mapper
	;;
	gdb)
		libtool --mode=execute gdb mapper
	;;
	strace)
		libtool --mode=execute strace mapper
	;;
	*)
		echo "Mode: valgrind or massif"
	;;
esac
