/*
 * Copyright (C) 2010 Pierre-Luc Beaudoin <pierre-luc@pierlux.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTRCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MAP_BUDDY_CONTACT_LAYER_H
#define MAP_BUDDY_CONTACT_LAYER_H

#include <champlain/champlain.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <libosso-abook/osso-abook.h>

G_BEGIN_DECLS

#define MAP_BUDDY_TYPE_CONTACT_LAYER     (map_buddy_contact_layer_get_type())
#define MAP_BUDDY_CONTACT_LAYER(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), \
      MAP_BUDDY_TYPE_CONTACT_LAYER, MapBuddyContactLayer))
#define MAP_BUDDY_CONTACT_LAYER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),  MAP_BUDDY_TYPE_CONTACT_LAYER, \
                           MapBuddyContactLayerClass))
#define MAP_BUDDY_IS_CONTACT_LAYER(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
      MAP_BUDDY_TYPE_CONTACT_LAYER))
#define MAP_BUDDY_IS_CONTACT_LAYER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),  MAP_BUDDY_TYPE_CONTACT_LAYER))
#define MAP_BUDDY_CONTACT_LAYER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj),  MAP_BUDDY_TYPE_CONTACT_LAYER, \
                             MapBuddyContactLayerClass))

typedef struct _MapBuddyContactLayerPrivate MapBuddyContactLayerPrivate;

typedef struct _MapBuddyContactLayer MapBuddyContactLayer;
typedef struct _MapBuddyContactLayerClass MapBuddyContactLayerClass;

struct _MapBuddyContactLayer
{
  GObject base;

  MapBuddyContactLayerPrivate *priv;
};

struct _MapBuddyContactLayerClass
{
  GObjectClass parent_class;
};

GType map_buddy_contact_layer_get_type (void);

MapBuddyContactLayer *map_buddy_contact_layer_new (void);

void map_buddy_contact_layer_start (MapBuddyContactLayer *self,
    ChamplainLayer *champlain_layer, GtkWindow *main_window);

G_END_DECLS

#endif
