/*
 * Copyright (C) 2010 Pierre-Luc Beaudoin <pierre-luc@pierlux.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _MAP_BUDDY_WINDOW_H
#define _MAP_BUDDY_WINDOW_H

#include "me-marker.h"
#include "merchant.h"

#include <hildon/hildon.h>
#include <champlain/champlain.h>
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
#include <rest/rest-proxy.h>
#include <rest/rest-proxy-call.h>

G_BEGIN_DECLS

#define MAP_BUDDY_TYPE_WINDOW map_buddy_window_get_type()

#define MAP_BUDDY_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MAP_BUDDY_TYPE_WINDOW, MapBuddyWindow))

#define MAP_BUDDY_WINDOW_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MAP_BUDDY_TYPE_WINDOW, MapBuddyWindowClass))

#define MAP_BUDDY_IS_WINDOW(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MAP_BUDDY_TYPE_WINDOW))

#define MAP_BUDDY_IS_WINDOW_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MAP_BUDDY_TYPE_WINDOW))

#define MAP_BUDDY_WINDOW_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MAP_BUDDY_TYPE_WINDOW, MapBuddyWindowClass))

typedef struct _MapBuddyWindow MapBuddyWindow;
typedef struct _MapBuddyWindowClass MapBuddyWindowClass;


struct _MapBuddyWindow
{
  HildonStackableWindow parent;

  /* Menu */
  GtkWidget *copy_item;

  /* Toolbar */
  GtkWidget *toolbar;
  GtkWidget *center_button;
  GtkWidget *layer_button;

  /* Search */
  GtkWidget *search_entry;
  const gchar* current_search; /* Current search source */
  GList *merchants;
  ChamplainLayer *merchant_layer;

  GtkWidget* embed;
  ChamplainView *view;
  const gchar* current_layer; /* Current map source */

  ChamplainLayer *layer;
  ClutterActor *me_marker;


  LocationGPSDControl *gps_control;
  LocationGPSDevice *gps_device;
  gboolean has_fix;
  gfloat latitude;
  gfloat longitude;

  gint loading_count; /* How many time loading_push was called */
  gboolean show_warning; /* Show bandwidth warning on start up */

  /* Search calls */
  RestProxy *proxy;
  RestProxyCall *call;
};

struct _MapBuddyWindowClass
{
  HildonStackableWindowClass parent_class;
};

GType map_buddy_window_get_type (void);

MapBuddyWindow* map_buddy_window_new (void);

void map_buddy_window_show_details (MapBuddyWindow *self, MapBuddyMerchant *merchant);
void map_buddy_window_clear_merchants (MapBuddyWindow *self);

void map_buddy_window_loading_push (MapBuddyWindow *self);
void map_buddy_window_loading_pop (MapBuddyWindow *self);

G_END_DECLS

#endif /* _MAP_BUDDY_WINDOW_H */
