#! /bin/sh

# Save the user's original keyboard layout unless the file already exists (which indicates incomplete exit 
if [ ! -f $HOME/.mame/int_kb_layout ]
then
	/usr/bin/gconftool-2 -g /apps/osso/inputmethod/int_kb_layout > $HOME/.mame/int_kb_layout
fi

# Change layout to QWERTY
/usr/bin/gconftool-2 -s /apps/osso/inputmethod/int_kb_layout us -t string


# See if accelemymote is installed and not running. Start it up if so...
if [ -f /opt/maemo/usr/bin/accelemymote ] && [ ! -f /home/user/.accelemymote/live-trigger ]; then
	touch /home/user/.accelemymote/live-trigger
	/opt/maemo/usr/bin/accelemymote &

	# Fork off MAME and then wait and check for inversion of the device for 5 seconds...
	/opt/mame/mame -inipath "$HOME/.mame" $1 $2 $3 &
	PID=$!
	usetilt=0
	for tries in 1 2 3 4; do
		sleep 1
		if [[ $(awk '{print $3}' < /sys/class/i2c-adapter/i2c-3/3-001d/coord) -ge 0 ]]; then
			usetilt=1
		fi
	done
	# If it doesn't happen, kill accelemymote
	if [[ $usetilt = 0 ]]; then
		rm  /home/user/.accelemymote/live-trigger
	fi
	# Wait for MAME to finish
	wait $PID
	# Okay, now kill it then
	if [[ $usetilt = 1 ]]; then
		rm  /home/user/.accelemymote/live-trigger
	fi
else 
	/opt/mame/mame -inipath "$HOME/.mame" $1 $2 $3
fi

# Change layout back to saved value and delete the file
/usr/bin/gconftool-2 -s /apps/osso/inputmethod/int_kb_layout $(cat $HOME/.mame/int_kb_layout) -t string
rm $HOME/.mame/int_kb_layout

#-samplepath          path to samplesets
#-artpath             path to artwork files
#-ctrlrpath           path to controller definitions
#-fontpath            path to font files
#-cheatpath           path to cheat files
#-crosshairpath       path to crosshair files

#-cfg_directory       directory to save configurations
#-nvram_directory     directory to save nvram contents
#-memcard_directory   directory to save memory card contents
#-input_directory     directory to save input device logs
#-state_directory     directory to save states
#-snapshot_directory  directory to save screenshots
#-diff_directory      directory to save hard drive image difference files
