#ifndef CLOCK_H
#define CLOCK_H

#include <QGraphicsItem>
#include <game.h>
#include <baseobj.h>
#include <view.h>
#include <soundengine.h>

class Game;
class SoundEngine;

class Clock: public QWidget, public QGraphicsItem, public BaseObj
{
	Q_OBJECT

public:
		Clock();
		void paint(QPainter* painter, const QStyleOptionGraphicsItem *option, QWidget* widget);
		QRectF boundingRect() const;
		int value;
		qreal x;
		qreal y;
		int bahValue;
		static Game* game;	
private:
		void advance(int step);

public slots:
	void tick();



};





#endif
