#ifndef PLATFORM_H
#define PLATFORM_H

#include <baseobj.h>
#include <algorithm>
#include <QGraphicsItem>
#include <game.h>
#include <view.h>
#include <sheep.h>
#include <vector>
#include <QPainterPath>

class Sheep;
class View;
class Fence;
class Game;

class Platform: public QWidget, public QGraphicsItem, public BaseObj
{
	Q_OBJECT

public:

		Platform(qreal x_, qreal y_, qreal sizeX_, qreal sizeY_, int type_, int sheepTh_);
		qreal x;
		qreal y;
		qreal sizeX;
		qreal sizeY;
		int type;
		int sheepCounter;
		int sheepTh;
		std::vector<Fence*> connectedFences;
		std::vector<Sheep*> sheeps;
		void paint(QPainter* painter, const QStyleOptionGraphicsItem *option, QWidget* widget);
		QRectF boundingRect() const;
		int activated;
		void addFence(Fence* fence_);
		void deleteFence(Fence* fence_);
		int counter;
		void addSheep(Sheep* sheep_);
		static Game* game;
			
private:
		void advance(int step);


		void activate();
		void deactivate();
};


#endif
