#include <game.h>

View* Game::view=NULL;

double Game::frequency=0;
int Game::inWhistle=0;
int Game::frequencyChanged=0;
double Game::dogValue=10;

Game::Game():QWidget(0)
{
	sheepPix.load("/home/opt/MaeSheep/images/shp.png");
	fencePix.load("/home/opt/MaeSheep/images/fence.png");
	fenceClosedPix.load("/home/opt/MaeSheep/images/fenceC.png");
	grassPix.load("/home/opt/MaeSheep/images/grass.png");
	dogPix.load("/home/opt/MaeSheep/images/dog.png");
	iconExitPix.load("/home/opt/MaeSheep/images/sheep_exit.png");
	iconSoundOnPix.load("/home/opt/MaeSheep/images/sheep_sound-on.png");
	iconSoundOffPix.load("/home/opt/MaeSheep/images/sheep_sound-off.png");
	iconPlayPix.load("/home/opt/MaeSheep/images/sheep_play.png");
	iconPausePix.load("/home/opt/MaeSheep/images/sheep_pause.png");
	iconWhistlePix.load("/home/opt/MaeSheep/images/whistle_g.png");
	
	acc=AccSensor::New();
	
// 	levelZeroX = acc->getRotationDeg()+90;
	levelZeroX=acc->getX();
	levelZeroY = ((int)acc->getPitchDeg()+360)%360;

	lastX=acc->getX();
	lastY=acc->getY();
	lastZ=acc->getZ();
	
	connectToDbusVibra();
	connectToDbusSignal();

	soundEngine=new SoundEngine();

	sound = 1;

	pauseOn=0;
	

	sheepToHerd=3;
	won=0;

	backgroundPlaying=0;
	connectToDbusTune();
	
	startBackground();

	inWhistle=0;
	frequencyChanged=0;
	
}


void Game::connectToDbusSignal()
{
	dbus_error_init(&errSig);
	connSig = dbus_bus_get_private(DBUS_BUS_SESSION, &errSig);
	
	if (dbus_error_is_set(&errSig))
	{
		dbus_error_free(&errSig);
	}
	
	if (NULL == connSig)
	{
		exit(1);
	}
	
	retSig = dbus_bus_request_name(connSig, "maesheep.signal.source", DBUS_NAME_FLAG_REPLACE_EXISTING , &errSig);
	
	if (dbus_error_is_set(&errSig))
	{
		dbus_error_free(&errSig);
	}

	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retSig)
	{
		exit(1);
	}
	
}


void Game::emitState(int state_) //emitting change signals
{

	double state=state_;

	msgSig = dbus_message_new_signal("/maesheep/signal/state", // object name of the signal
			"mae.signal.state", // interface name of the signal
			"changed"); // name of the signal
	
	if (NULL == msgSig)
	{
		return;
	}
	
	dbus_message_iter_init_append(msgSig, &argsSig);
	
	if (!dbus_message_iter_append_basic(&argsSig, DBUS_TYPE_DOUBLE, &state))
	{
		return;
	}

	if (!dbus_connection_send(connSig, msgSig, &serialSig))
	{
		return;
	}

	
}



void Game::connectToDbusTune()
{

	dbus_error_init(&errTune);
	connTune = dbus_bus_get_private(DBUS_BUS_SESSION, &errTune);

	if (dbus_error_is_set(&errTune))
	{
		dbus_error_free(&errTune);
	}
	
	if (NULL == connTune)
	{
		return;
	}
	
	retTune = dbus_bus_request_name(connTune, "sheep.tune", DBUS_NAME_FLAG_REPLACE_EXISTING , &errTune);

	if (dbus_error_is_set(&errTune))
	{
		dbus_error_free(&errTune);
	}

	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retTune)
	{
		return;
	}
	
	dbus_bus_add_match(connTune, "type='signal',interface='tune.signal.state'", &errTune);
	dbus_connection_flush(connTune);
	
	if (dbus_error_is_set(&errTune))
	{
		return;
	}
	connectedTune=1;
}


void Game::readTune()
{


	if (connectedTune==0)
	{
		connectToDbusTune();
	}
	
	dbus_connection_read_write(connTune, 0);

	msgTune = dbus_connection_pop_message(connTune);

	if (NULL == msgTune)
	{
		return;
	}

	else
	{
		if (dbus_message_is_signal(msgTune, "tune.signal.state", "changed"))
		{
			if (!dbus_message_iter_init(msgTune, &argsTune))
				return;
			else if (DBUS_TYPE_DOUBLE != dbus_message_iter_get_arg_type(&argsTune))
				return;
			else
				dbus_message_iter_get_basic(&argsTune, &sigvalueTune);
				
		}
	}
}



DBusHandlerResult Game::DBusCallback( DBusConnection* connection, DBusMessage* message, void* user_data)
{

	double freq;
	DBusError errTune_;
	
	if (!inWhistle)
		return DBUS_HANDLER_RESULT_HANDLED;

	dbus_error_init (&errTune_);
	
	if (dbus_message_is_signal (message, "tune.signal.state", "changed"))
	{
		if (dbus_message_get_args(message, &errTune_, DBUS_TYPE_DOUBLE, &freq, DBUS_TYPE_INVALID))
		{
			frequency=freq;
			if (frequency < 2500 && frequency > 400)
			{
				std::cout<<"YES"<<std::endl;
				dogValue=dogValue+1;
				if (dogValue>10)
					dogValue=10;
			}
			frequencyChanged=1;	
			
		}
		
		return DBUS_HANDLER_RESULT_HANDLED;
	}

	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}








void Game::startBackground()
{

	if (!backgroundPlaying)
	{
		std::cout<<"starting background playback"<<std::endl;
		backgroundThread;
		pthread_create(&backgroundThread,NULL,&SoundEngine::playBackground,NULL);
		backgroundPlaying=1;
	}

}

void Game::stopBackground()
{
	if (backgroundPlaying)
	{
		std::cout<<"stopping background playback"<<std::endl;
		soundEngine->background->pause();
		backgroundPlaying=0;


	}
	

}

void Game::caught()
{

	--sheepToHerd;
	if (sheepToHerd==0)
		win();
}


void Game::win()
{
	
	pauseOn=1;
	won=1;
	view->clock->setPos(220,80);
	view->win();

	
}


void Game::connectToDbusVibra()
{

	dbus_error_init(&errVib);
	connVib = dbus_bus_get_private(DBUS_BUS_SYSTEM, &errVib);
	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}

	
	if (NULL == connVib)
	{
		return;
	}

	retVib = dbus_bus_request_name(connVib, "sheep.vibra", DBUS_NAME_FLAG_REPLACE_EXISTING , &errVib);

	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}

	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retVib)
	{
		return;
	}
	connectedVib=1;
}

void Game::vibrate(int type)
{

        if (type==0) //change this to enum
        {
                paramVib = "PatternTouchscreen";
        }

        else if (type==1)
        {
                paramVib = "PatternPowerKeyPress";
        }

        else if (type==2)
        {
                paramVib= "PatternChatAndEmail";
        }

        if (connectedVib==0)
        {
                connectToDbusVibra();
                if (connectedVib==0)
                        return;
        }

        msgVib = dbus_message_new_method_call("com.nokia.mce",
                        "/com/nokia/mce/request",
                        "com.nokia.mce.request",
                        "req_vibrator_pattern_activate");



        if (NULL == msgVib)
        {
                return;
        }

        dbus_message_iter_init_append(msgVib, &argsVib);

        if (!dbus_message_iter_append_basic(&argsVib, DBUS_TYPE_STRING, &paramVib))
        {
                return;
        }

        if (!dbus_connection_send_with_reply (connVib, msgVib, &pendingVib, -1))
        {
                return;
        }

        if (NULL == pendingVib)
        {
                return;
        }

        dbus_connection_flush(connVib);
        dbus_message_unref(msgVib);

}

