###################
################### Do zrobienia:
#################    - ukrywanie aplikacji, updateminiatures przy aktywacji okna
#- poprawa przyblizenia
#- poprawa wykrywania orientacji
import sys
from PySide.QtCore import QThread, QTimer, QObject, QEvent, QPoint, QCoreApplication, Qt, QSize
from PySide import QtMaemo5
from PySide.QtMaemo5 import *
from PySide.QtGui import QImageReader, QWidget, QGesture, QImage, QMessageBox, QMenu, QDialog, QPushButton, QApplication, QFileDialog, QDesktopWidget, QInputDialog, QSizePolicy, QScrollArea, QIcon, QGridLayout, QAction, QPalette, QToolButton, QMainWindow, QPixmap, QLabel
import os, glob, md5, math
import dbus
import dbus.service
import dbus.mainloop.glib

class myDBus(dbus.service.Object):  ############ DBus connection class ######
 def __init__(self, b, object_path="/"):
   dbus.service.Object.__init__(self, b, object_path)

 @dbus.service.signal('com.nokia.hildon_desktop')
 def exit_app_view(self, message):
  #wyslanie komunikatu exit_app_view do hildon_desktop 
  pass

class Thread(QThread):  #klasa watku od usuwania zdjec
  def __init__(self, parent=None):
    super(Thread, self).__init__()
    self.parent = parent
  def run(self):
    if self.parent.pix != None:
      del self.parent.pix
    self.parent.deleteSelected()

class LoadPixThread(QThread):
  def __init__(self, parent=None):
    super(LoadPixThread, self).__init__()
    self.parent = parent
  def run(self):
    self.parent.images = range(len(self.parent.licz))
    i=0
    while i < len(self.parent.licz):
      self.parent.images[i] = QImage(self.parent.licz[i])
      i+=1
      
    print self.parent.images
    
class PixBtn(QToolButton):  #klasa ikon z miniaturami  
  path = ""
  index = 0
  send = 0
  toDelete = 0
  def __init__(self, par, path, index, licz, parent=None):
    super(PixBtn, self).__init__()
    self.path = path
    self.index = index
    self.parent = par
#    self.timer = QTimer()
#    self.timer.timeout.connect(self.timeOut)
#    
    self.deleteAct = QAction("&Delete",self)
    self.deleteAct.triggered.connect(self.markToDelete)
    
    self.pop = QMenu(self)
    self.pop.addAction(self.deleteAct)
#    self.setContextMenuPolicy(Qt.ActionsContextMenu)
    self.setMenu(self.pop)
    self.setMinimumHeight(115)
    self.setMinimumWidth(115)
    self.setMaximumWidth(182)
    self.setMaximumHeight(115)    
    self.setStyleSheet("background-color: rgba(0,0,0,0%);")
    self.clicked.connect(self.clickk)
    
  def clickk(self):
    print self.index
    self.parent.showPix(self.index)
    
  def markToDelete(self):
    if self.toDelete == "yes":
      self.toDelete = "no"      
      self.deleteAct.setText("Delete")
      self.setStyleSheet("QToolButton { background-color: rgba(0,0,0,0); }")
      print self.path, "unmarked"    
    else:
      self.toDelete = "yes"
      self.deleteAct.setText("Don't delete")
      self.setStyleSheet("QToolButton { background-color: rgb(255,0,0); }")
      print self.path, "marked to delete"
#  def mousePressEvent(self, e):
#    self.timer.start(500)
#    print "nacisniety"
#   
#  def timeOut(self):
#    self.timer.stop()
#    self.showMenu()
#      
#  def mouseMoveEvent(self, e):
#    pass
#  def mouseReleaseEvent(self, e):
#    if self.timer.isActive():
#      self.timer.stop()
#      self.parent.showPix(self.index)
#    else:
#      pass
#      self.showMenu()
#      
#  def event(self, e):
#    if e.type() == QEvent.MouseButtonPress:
#      print "nacisniety"
#      return True
#    return True
    
class PixWindow(QMainWindow):  ######### Second Window Class ###########
  imageLabel = QLabel
  scrollArea = 0
  flag = 0
  licz = 0
  index = 0
  pixmap = 0
  dbus = None
  def __init__(self, dbus, licz, index,parent=None):
    super(PixWindow, self).__init__()
    self.licz = licz
    self.index = index
    self.dbus = dbus
    self.grabMouse()
    self.parent = parent
    self.reader = QImageReader()
    self.destroyed.connect(self.delete)

  def mouseEvent(self, e):
    print e.type()
    return QWidget.event(self, e)  
  
  def mouseReleaseEvent(self, e):
#    print "mouse released at ", e.pos()
    if math.fabs((self.xPos - e.x())) > 200 and self.imageLabel.height() <= self.height() and self.imageLabel.width() <= self.width(): #self.scrollArea.horizontalScrollBar().value() == 0:
      if self.xPos - e.x() < 0:
        self.prevPix()
        self.xPos = None
        self.yPos = None
      else:
        self.nextPix()
        self.xPos = None
        self.yPos = None
    elif math.fabs((self.yPos - e.y())) > 200 and self.imageLabel.height() <= self.height() and self.imageLabel.width() <= self.width():# and self.scrollArea.horizontalScrollBar().value() == 0:
      if self.yPos - e.y() < 0:
        self.minimalizePix()
        self.xPos = None
        self.yPos = None
      else:
        self.fitPix()
        self.xPos = None
        self.yPos = None
      
  def mousePressEvent(self, e):
#    print "mouse pressed at ", e.pos()
    self.xPos = e.x()
    self.yPos = e.y()

  def delete(self):
    del self
    
  def closeEvent(self, e):
    print "close event occur"
    del self
    
  def showEvent(self, e):
    self.scrollArea.move(300,0)
     
  def keyPressEvent(self, e):
    print e.key()
    if e.key() == Qt.Key_Q:
      self.close()
    elif e.key() == Qt.Key_Z:
      self.flag = 1
      w = self.imageLabel.width() + self.imageLabel.width()*0.1
      h = self.imageLabel.height() + self.imageLabel.height()*0.1
      self.imageLabel.resize(w,h)
      self.scrollArea.horizontalScrollBar().setValue(self.scrollArea.horizontalScrollBar().value()+150)  
      self.scrollArea.horizontalScrollBar().setValue(self.scrollArea.verticalScrollBar().value()+150)
    elif e.key() == Qt.Key_X:
      w = self.imageLabel.width() - self.imageLabel.width()*0.1
      h = self.imageLabel.height() - self.imageLabel.height()*0.1
      self.imageLabel.resize(w,h)
      self.scrollArea.horizontalScrollBar().setValue(self.scrollArea.verticalScrollBar().value()-50)
      self.scrollArea.horizontalScrollBar().setValue(self.scrollArea.horizontalScrollBar().value()-50)
    elif e.key() == Qt.Key_Space:
      self.nextPix()
    elif e.key() == Qt.Key_M:
      self.prevPix()
    elif e.key() == Qt.Key_C:
      self.fitPix()
      

  def fitPix(self): #resize pix to oryginal pix size
    # tworzymy temp pixmap, skalujemy do szerokosci ekranu, dostajemy 
    # wysokosc ktora trzyma aspect ratio
    # przypisujemy do imagelabel ktory jest naszym stolem dla obrazu
    # ustawiamy scrollarea zeby obrazek maly byl na srodku ekranu
    # dzielimy wysokosc ekranu przez 2, nastepnie odejmujemy wysokosc
    # imagelabel
#    self.imageLabel.setPixmap(self.imageLabel.pixmap().scaledToHeight(800))
#    if self.parent.checkOrientation() == "portrait":
    p = QPixmap(self.imageLabel.pixmap().scaledToWidth(self.width()))
#    else:
#      p = QPixmap(self.imageLabel.pixmap().scaledToHeight(self.height()))
    self.imageLabel.resize(self.width(), p.height())
    if p.height() < self.height():
#      print p.height(), self.height()
      self.scrollArea.move(0, (self.height()/2)-(self.imageLabel.height()/2))
#      print 0, (self.height()/2)-(self.imageLabel.height()/2)
    else:
      self.scrollArea.move(0,0)
      
  def minimalizePix(self):
    self.dbus.exit_app_view("MaePyGallery - minimalize")
    
  def nextPix(self):
    if self.index+1 == len(self.licz):
      self.index = 0
    else:
      self.index = self.index+1
    print self.licz[self.index]
    
    self.reader.setFileName(self.licz[self.index])  
    self.fitPix()
    #w while wykonuje sie animacja :) zwykly move + procevent
    i=0
    temp = self.width()/9
    while i > -self.width():
      self.imageLabel.move(i,0)
      i-=temp
      QApplication.processEvents()
    pix = QPixmap(self.reader.read())
    self.imageLabel.setPixmap(pix)
    self.fitPix()
    self.setWindowTitle(str(self.licz[self.index]))
    
  def prevPix(self):
    if self.index == 0:
      self.index = len(self.licz)-1
    else:
      self.index = self.index-1

    self.reader.setFileName(self.licz[self.index])  
    self.fitPix()
    i=0
    temp = self.width()/9
    while i < self.width():
      self.imageLabel.move(i,0)
      i+=temp
      QApplication.processEvents()
    pix = QPixmap(self.reader.read())
    self.imageLabel.setPixmap(pix)
    self.fitPix()
    self.setWindowTitle(str(self.licz[self.index]))
    
  def mouseDoubleClickEvent(self, e):  #powiekszanie obrazka w nacisnietym miejscu
    print self.flag
    if self.flag == 0:    
      if self.imageLabel.height() < self.height(): #operowanie na podstawie wartosci scrollbara
        p = QPixmap(self.imageLabel.pixmap()).scaledToHeight(800)
        self.imageLabel.resize(p.width(), p.height()-10)
        self.scrollArea.move(0,0)
        tempV = p.height()/2        
        tempH = p.width()/2
        self.scrollArea.verticalScrollBar().setValue(tempV)
        self.scrollArea.horizontalScrollBar().setValue(tempH)
        self.flag = 1
#      self.scrollArea.move(0, (self.height()/2)-(self.imageLabel.height()/2))      
      else:
        self.imageLabel.resize(self.imageLabel.width()*2,self.imageLabel.height()*2)
        if self.scrollArea.horizontalScrollBar().value() == 0 and self.scrollArea.verticalScrollBar().value() == 0:
          self.scrollArea.horizontalScrollBar().setValue(e.x())
          self.scrollArea.verticalScrollBar().setValue(e.y())  
        elif self.scrollArea.horizontalScrollBar().value() == 0:
          self.scrollArea.horizontalScrollBar().setValue(e.x())
        elif self.scrollArea.horizontalScrollBar().value() == 0:
          self.scrollArea.horizontalScrollBar().setValue(e.y()) 
        else:
          self.scrollArea.horizontalScrollBar().setValue(self.scrollArea.horizontalScrollBar().value()*3)
          self.scrollArea.verticalScrollBar().setValue(self.scrollArea.verticalScrollBar().value()*3)
      self.flag = 1    
    elif self.flag == 1:
      self.fitPix()
      self.flag = 0
    
class Main(QMainWindow): ################## Main Class ##################
  dbus = myDBus
  loop = None
  licz = [] 
  pathList = [] 
  miniatures = None
  pix = None
  label = QLabel
  scrollarea = QScrollArea
  layoutLandscape = QGridLayout
  layoutPortrait = QGridLayout
  laySpacing = 10
  size = 6
  dirPix = "/home/user/MyDocs/Programy_python"
  adjustedHeight = 0
  
  def __init__(self, size, parent=None):
    super(Main, self).__init__()
 
    self.reader = QImageReader()
    self.setWindowTitle("MaePyGallery - " + self.dirPix)
    self.showMaximized()
    self.a = Thread(self)
    self.a.finished.connect(self.updateMiniatures)
    self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 1)
    dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
    self.dbus = myDBus(dbus.SessionBus())
    self.createMenus()
    self.initUi()
    QApplication.desktop().resized.connect(self.orientationChanged)  #odbieranie sygnalu zmienienia rozmiarow okna
    self.setWindowTitle("MaePyGallery - " + self.dirPix)
    
  def createMenus(self):
  
    helpDialog = QAction("&Help", self)
    helpDialog.triggered.connect(self.helpDialog)

    aboutDialog = QAction("&About", self)
    aboutDialog.setShortcut("Ctrl+A")
    aboutDialog.triggered.connect(self.aboutDialog)
  
    chDirAct = QAction("&Change directory", self)
    chDirAct.setShortcut("Ctrl+D")
    chDirAct.triggered.connect(self.chPixDir)
    
    exitAct = QAction("&Exit",self)
    exitAct.setShortcut("Ctrl+Q")
    exitAct.triggered.connect(self.closee)
    
    self.deleteAct = QAction("&Delete selected",self)
    self.deleteAct.setShortcut("Ctrl+D")
    self.deleteAct.triggered.connect(self.a.start)#self.deleteSelected)
        
    self.refreshAct = QAction("&Refresh",self)
    self.refreshAct.setShortcut("Ctrl+R")
    self.refreshAct.triggered.connect(self.updateMiniatures)
    
    self.menubar = self.menuBar()
    self.fileMenu = self.menubar.addMenu("&File")
    self.fileMenu.addAction(chDirAct)
    self.fileMenu.addAction(helpDialog)
    self.fileMenu.addAction(self.refreshAct)
    self.fileMenu.addAction(aboutDialog)
    self.fileMenu.addAction(self.deleteAct)
    self.fileMenu.addAction(exitAct)
      
  def initUi(self):
    # ustawienie dla przypadku obkrecenia telefonem podczas ladowania zdjec
    # stwarzalo to bledy, zablokowanie sygnalow podczas ladowania
    QApplication.desktop().blockSignals(True)
    if self.miniatures != None: #usuwanie altualnych miniatur, wywolywane jesli user zmieni katalog
      del self.miniatures[:]

    self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 1)
    self.label = QLabel()
    self.label.setBackgroundRole(QPalette.Base)
    self.label.setSizePolicy(QSizePolicy.Ignored, QSizePolicy.Ignored)
    self.label.setScaledContents(True)
    self.labelP = QLabel()
    self.labelP.setBackgroundRole(QPalette.Base)
    self.labelP.setSizePolicy(QSizePolicy.Ignored, QSizePolicy.Ignored)
    self.labelP.setScaledContents(True)
    
    self.scrollArea = QScrollArea()
    self.scrollArea.setBackgroundRole(QPalette.Dark)
    self.setCentralWidget(self.scrollArea)
    os.chdir(self.dirPix)
    if len(self.licz) != 0:
      del self.licz[:]
      
#    self.licz = glob.glob(self.dirPix+"/*.jpg")
#    templ = glob.glob(self.dirPix+"/*.jpeg")
    li = os.listdir(os.getcwd())
    for i in range(len(li)):
      if li[i].endswith("jpg") or li[i].endswith("jpeg"):
        self.licz.append(li[i]) 
    self.licz.sort()
    #tworzenie listy do sprawdzania sumy md5
    self.listForSum = range(len(self.licz))
    for i in range(len(self.licz)):
      self.listForSum[i] = "file://"+ self.dirPix+"/" + self.licz[i]
    
    self.thumbList = os.listdir("/home/user/.thumbnails/cropped")
    la = os.listdir("/home/user/.thumbnails/normal")
    #usuniecie koncowki .jpegz listy
    for i in range(len(self.thumbList)):
      self.thumbList[i] = self.thumbList[i][:-5]
#    print self.thumbList
    
    #tworzenie listy ze sciezkami do miniaturek zdjec ktore sa w wybranym katalogu
    self.miniaturki = range(len(self.licz))
    for i in range(len(self.licz)):
      a = md5.new(self.listForSum[i]).hexdigest() #suma kontrolna
#      print a
      if a in self.thumbList:
#        print str(a)+".jpeg"
        self.miniaturki[i] = (str(a)+".jpeg")
      else:
        print "nie ma", self.listForSum[i], self.licz[i]
#    print self.miniaturki
    os.chdir("/home/user/.thumbnails/cropped")
 
#    return
    
    if len(self.licz) == 0:  # there is no jpg's in dir
      self.box = QtMaemo5.QMaemo5InformationBox()
      self.box.information(self, "<br><b>No pictures in directory<b><br>", 10000)
      self.box.show()
      self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 0)
      return
      
    self.refreshAct.setDisabled(True)
    self.deleteAct.setDisabled(True)
    self.layoutLandscape = QGridLayout(self.label)
    self.layoutPortrait = QGridLayout(self.labelP)
    self.miniatures = range(len(self.miniaturki))#len(self.licz))
    self.pathList = range(len(self.miniaturki))    
    j=0    
    k=0
    i=0
    self.layoutLandscape.setSpacing(self.laySpacing)
    self.layoutPortrait.setSpacing(self.laySpacing)
    if self.checkOrientation() == "landscape": #landscape loading
      self.size = 6
      self.scrollArea.setWidget(self.label)
      while i < len(self.miniaturki):#self.licz):
        if k==self.size:
          j+=1
          QApplication.processEvents()
           # jesli pojawia sie wiecej niz 3 wiersze to zwieksz wysokosc widgetu
          self.adjustedHeight = self.label.height()+125
          self.label.resize(self.width()-15, self.adjustedHeight)
          self.labelP.resize(self.width()-15, self.adjustedHeight)
          self.scrollArea.verticalScrollBar().setValue(self.adjustedHeight)
          k=0
#        self.reader.setFileName(self.licz[i])
#        print self.miniaturki[i]
        if type(self.miniaturki[i]) == int:
#          print self.miniaturki[i:]
          break
        pixmap = QPixmap(self.miniaturki[i])#self.licz[i])#self.reader.read()).scaledToHeight(115)
        if not pixmap.isNull():
          self.miniatures[i] = PixBtn(self, self.licz[i], i, self.label)
          self.miniatures[i].setIconSize(QSize(pixmap.width(),pixmap.height()))
          self.miniatures[i].setIcon(QIcon(pixmap))
          self.miniatures[i].blockSignals(True)
          #self.miniatures[i].clicked.connect(self.showPix)
          self.layoutLandscape.addWidget(self.miniatures[i],j,k)
          k+=1
          self.pathList[i] = self.licz[i]
        else:
          print "null pixmap", self.licz[i]
          
#        QApplication.processEvents()
        #przesuwanie okna za ladowanymi zdjeciami
        text = "Loaded "+str(i+1)+"/"+str(len(self.licz))+" files"
        self.setWindowTitle(text)
        i+=1
        
      self.label.setLayout(self.layoutLandscape)
      self.scrollArea.setWidget(self.label)
      self.setCentralWidget(self.scrollArea)
      self.box = QtMaemo5.QMaemo5InformationBox()
      self.box.information(self, "<b>Loading completed<b>", 3000)
      self.box.show()
      QApplication.processEvents()
      self.setWindowTitle("MaePyGallery - " + self.dirPix)
      self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 0)
        
    else:  #portrait loading
      self.size = 3
      self.scrollArea.setWidget(self.labelP)
      while i < len(self.miniaturki):
        if k==self.size:
          j+=1
#          QApplication.processEvents()
           # jesli pojawia sie wiecej niz 3 wiersze to zwieksz wysokosc widgetu
          self.adjustedHeight = self.label.height()+125
          self.label.resize(self.width()-15, self.adjustedHeight)
          self.labelP.resize(self.width()-15, self.adjustedHeight)
          self.scrollArea.verticalScrollBar().setValue(self.adjustedHeight)
          k=0
        if type(self.miniaturki[i]) == int:
          break
        pixmap = QPixmap(self.miniaturki[i])#self.licz[i]).scaledToHeight(115)
        if not pixmap.isNull():
          self.miniatures[i] = PixBtn(self, self.licz[i], i, self.labelP)
          self.miniatures[i].setIconSize(QSize(pixmap.width(),pixmap.height()))
          self.miniatures[i].setIcon(QIcon(pixmap))
          self.miniatures[i].blockSignals(True)
          #self.miniatures[i].clicked.connect(self.showPix)
          self.layoutPortrait.addWidget(self.miniatures[i],j,k)
          k+=1
          self.pathList[i] = self.licz[i]
        else:
          print "null pixmap"
        
        QApplication.processEvents()
        text = "Loaded "+str(i+1)+"/"+str(len(self.licz))+" files"
        self.setWindowTitle(text)
        i+=1
        
      self.labelP.setLayout(self.layoutPortrait)
      self.scrollArea.setWidget(self.labelP)
      self.setCentralWidget(self.scrollArea)
      self.setWindowTitle("MaePyGallery - " + self.dirPix)
      self.box = QtMaemo5.QMaemo5InformationBox()
      self.box.information(self, "<br><b>Loading is done<b><br>", 5000)  
      self.box.show()
      self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 0)
      #odblokowanie sygnalow
      
    QApplication.desktop().blockSignals(False)
    #przesuwanie okna na koniec
    self.scrollArea.verticalScrollBar().setValue(self.adjustedHeight)      
    self.refreshAct.setDisabled(False)
    self.deleteAct.setDisabled(False)    
    os.chdir(self.dirPix)
    self.orientationChanged()
    
  def showPix(self, index):
    self.pix = PixWindow(self.dbus, self.licz, index, self)
    self.pix.setStyleSheet("QToolButton { background-color: rgba(0,0,0,0%); }")
    self.pix.setWindowTitle(str(self.licz[index]))
    self.pix.imageLabel = QLabel()
    self.pix.scrollArea = QScrollArea()
    self.pix.imageLabel.setBackgroundRole(QPalette.Base)
    self.pix.imageLabel.setSizePolicy(QSizePolicy.Ignored, QSizePolicy.Ignored)
    self.pix.imageLabel.setScaledContents(True)
    self.pix.scrollArea.setBackgroundRole(QPalette.Dark)
    self.pix.setCentralWidget(self.pix.scrollArea)
    self.reader.setFileName(self.licz[index])#self.sender().path)
    bla = QPixmap(self.reader.read())
    if bla.isNull():
      print "kurwa"
    self.pix.pix = bla#.scaledToWidth(QApplication.desktop().width())
    self.pix.imageLabel.setPixmap(self.pix.pix)##.scaledToHeight(self.pix.pix.height()/2)
    self.pix.scrollArea.setWidget(self.pix.imageLabel)
          
    self.pix.prevPixBtn = QToolButton(self.pix)
    self.pix.prevPixBtn.setGeometry(0,0,50,self.height()+50)
    self.pix.prevPixBtn.released.connect(self.pix.prevPix)
    self.pix.restorePixSize = QToolButton(self.pix)
    self.pix.restorePixSize.setGeometry(0,self.height()+10,self.width(), 50)
    self.pix.restorePixSize.released.connect(self.pix.fitPix)
    self.pix.nextPixBtn = QToolButton(self.pix)
    self.pix.nextPixBtn.setGeometry(self.width()-50,0,50, self.height()+50)
    self.pix.nextPixBtn.released.connect(self.pix.nextPix)
    self.pix.minimalizeBtn = QToolButton(self.pix)
    self.pix.minimalizeBtn.setGeometry(0,0,self.width(),50)
    self.pix.minimalizeBtn.released.connect(self.pix.minimalizePix)
    self.pix.minimalizeBtn.setStyleSheet("background-color: rgba(0,0,0,0%);")

    QApplication.processEvents()
    self.pix.showFullScreen()
    QApplication.processEvents()
    self.pix.update()
    self.pix.fitPix()
    print self.pix.index

  def closee(self):
    if self.pix != None:
      self.pix.close()    
    self.close()
    
#  def loadingLabel(self, show):
#    if show:
#      os.chdir(self.dirPix)
#      li = os.listdir(os.getcwd())
#      li.sort()
#      self.countPix = 0
#      for i in range(len(li)):
#        if li[i].endswith(".jpg") or li[i].endswith(".jpeg"):
#          self.countPix=self.countPix+1
#      text = "<center><b>Loading " + str(self.countPix) + " pictures from <hr>" + os.getcwd() + "<hr> Please wait. <b><center>"
#      self.loadingLabela = QLabel(text, self)
#      self.loadingLabela.setGeometry(0,0,450,300)
##      self.loadingLabela.show()
#      self.setCentralWidget(self.loadingLabela)
#    else:
#      self.loadingLabela.hide()
      
  def helpDialog(self):
    text = "Interface of second window: <br> Left border button - previous picture <br> Right border button - next picture <br> Upper border button - restore view <br> Bottom border button - minimalize window"
    temp = QMessageBox.information(self, "Help", text)
      
  def chPixDir(self):
    temp = QFileDialog.getExistingDirectory(self, "Choose dir", os.getcwd(), QFileDialog.ShowDirsOnly)
    if temp == self.dirPix:
      pass
    elif temp == '':
      pass
    else:
      self.dirPix = temp
      if self.pix != None:
        self.pix.close()
      self.initUi()   
    #self.showMaximized()
    
  def refreshPix(self):
   self.initUi() 
    
  def aboutDialog(self):
    text = "<center><b>MaePyGallery 0.1</b></center><br><br><b>Author:</b> Andrzej Machalski (jendkers@gmail.com) MaePyGallery written with <br>python and PySide (www.pyside.org)"
    
    dialog = QMessageBox.information(self, "About", text)
       
  def checkOrientation(self):
    if QApplication.desktop().width() > QApplication.desktop().height():
      return "landscape"
    else:
      return "portrait" 
  
  def orientationChanged(self):
    print self.checkOrientation()
    self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 1)
    self.setWindowTitle("Updating...")
    
    #obrot przyciskow w drugim oknie przegladania zdjec
    if self.pix != None:
      if self.pix.prevPixBtn != None:
        self.pix.prevPixBtn.setGeometry(0,0,30,self.height()+30)
        self.pix.restorePixSize.setGeometry(0,self.height()+10,self.width(), 50)
        self.pix.nextPixBtn.setGeometry(self.width()-30,0,30, self.height()+30)
        self.pix.minimalizeBtn.setGeometry(0,0,self.width(),50)
        self.pix.fitPix()
    self.label = QLabel()
    self.label.setBackgroundRole(QPalette.Base)
    self.label.setSizePolicy(QSizePolicy.Ignored, QSizePolicy.Ignored)
    self.label.setScaledContents(True)
#    self.label.setGeometry(0,0,800,400)
    self.labelP = QLabel()
    self.labelP.setBackgroundRole(QPalette.Base)
    self.labelP.setSizePolicy(QSizePolicy.Ignored, QSizePolicy.Ignored)
    self.labelP.setScaledContents(True)
#    self.labelP.setGeometry(0,0,800,400)

    self.layoutLandscape = QGridLayout(self.label)
    self.layoutPortrait = QGridLayout(self.labelP)    
    
    self.label.resize(self.width()-8,self.height())
    self.labelP.resize(self.width()-8,self.height())
    
    if self.checkOrientation() == "portrait":
      self.size = 3
      j=0    
      k=0
      i=0
      while i < len(self.miniatures):
        if k==self.size:
          j+=1
          k=0
          
          self.adjustedHeight = self.labelP.height()+125
          self.labelP.resize(self.width()-15, self.adjustedHeight)
        
        if type(self.miniatures[i]) != int:
          self.miniatures[i].index = i
          self.layoutPortrait.addWidget(self.miniatures[i],j,k)
          self.miniatures[i].blockSignals(False)
        else:
          pass        
        k+=1
        i+=1
#        QApplication.processEvents()
        
      self.labelP.setLayout(self.layoutPortrait)
      self.scrollArea.setWidget(self.labelP)
      self.setCentralWidget(self.scrollArea)
      
    elif self.checkOrientation() == "landscape" :
      self.size = 6
      j=0    
      k=0
      i=0
      while i < len(self.miniatures):
        if k==self.size:
          j+=1
          k=0
          
          self.adjustedHeight = self.label.height()+115
          self.label.resize(self.width()-15, self.adjustedHeight)
        if type(self.miniatures[i]) != int:
          self.miniatures[i].index = i
          self.layoutLandscape.addWidget(self.miniatures[i],j,k)
          self.miniatures[i].blockSignals(False)
        else:
          pass        
        k+=1
        i+=1
        
      self.label.setLayout(self.layoutLandscape)
      self.scrollArea.setWidget(self.label)
      self.setCentralWidget(self.scrollArea)
    
    self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 0)
    self.setWindowTitle("MaePyGallery " + self.dirPix)
    self.scrollArea.verticalScrollBar().setValue(self.adjustedHeight)

  def deleteSelected(self):
    self.setWindowTitle("Deleting...")
    deleteCount = 0    
    for i in self.miniatures:
      if i != type(int):        
        if i.toDelete == "yes":
          print "znalazlem do usuniecia"
          deleteCount+=1
          
    if deleteCount == 0:
      return
    
    while deleteCount != 0:
      for i in self.miniatures:
        if i != type(int):
          if i.toDelete == "yes":
            os.remove(i.path)
            print "usuwam plik i miniature:", i, i.path
            self.pathList.remove(i.path)
            self.miniatures.remove(i)
            print "poprawnie usunalem"
            deleteCount-=1
            
#    self.updateMiniatures() jest wywolywane sygnalem
    
  def updateMiniatures(self):
    if self.pix != None:
      del self.pix
    self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 1)
    self.setWindowTitle("Updating...")

    os.chdir(self.dirPix)
    if len(self.licz) != 0:
      del self.licz[:]
      
#    self.licz = glob.glob(self.dirPix+"/*.jpg")
#    templ = glob.glob(self.dirPix+"/*.jpeg")
    li = os.listdir(os.getcwd())
    for i in range(len(li)):
      if li[i].endswith("jpg") or li[i].endswith("jpeg"):
        self.licz.append(li[i]) 
    self.licz.sort()
    self.thumbList = os.listdir("/home/user/.thumbnails/cropped")
    #usuniecie koncowki .jpegz listy
    for i in range(len(self.thumbList)):
      self.thumbList[i] = self.thumbList[i][:-5]
    #tworzenie listy ze sciezkami do miniaturek zdjec ktore sa w wybranym katalogu
    self.miniaturki = range(len(self.licz))
    for i in range(len(self.licz)):
      a = md5.new("file://" + self.dirPix + "/" + self.licz[i]).hexdigest() #suma kontrolna
      #      print a
      if a in self.thumbList:
        self.miniaturki[i] = (str(a)+".jpeg")
    os.chdir("/home/user/.thumbnails/cropped")
    #old filelist refreshed, now look for new files    
    #self.pathList jest lista starych sciezek
    #przed refreshem przez glob 
    if len(self.pathList) == len(self.licz):
      print "correct"
    else:
      print "there are new files"
      for i in range(len(self.licz)):
        if self.licz[i] not in self.pathList: #pathlist is a list of miniatures paths
          print "nowy plik to: ", self.licz[i], i
          self.setWindowTitle("Inserting new files")
          if type(self.miniaturki[i]) == int: # if error miniture
            break 
          pixmap = QPixmap(self.miniaturki[i])#.scaledToHeight(115)
          if not pixmap.isNull():  
            self.miniatures.insert(i, PixBtn(self, self.licz[i], i, self.label))
            self.miniatures[i].setIconSize(QSize(pixmap.width(),pixmap.height()))
            self.miniatures[i].setIcon(QIcon(pixmap))
            self.miniatures[i].setStyleSheet("background-color: rgb(0,0,255);")
            self.miniatures[i].clicked.connect(self.showPix)
            self.pathList.append(self.licz[i])
            QApplication.processEvents()
            print self.miniatures[i].index
        elif not os.path.isfile(self.licz[i]):
          print "error"

    #dodac usuwanie zbednych plikow z pathlist

    self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, 0)
    os.chdir(self.dirPix)
    self.setWindowTitle("MaePyGallery " + self.dirPix)
    self.orientationChanged()

  def keyPressEvent(self, e):
    if e.key() == Qt.Key_Q:
      self.close()
      self.pix.close()
    if e.key() == Qt.Key_R :
      self.updateMiniatures()
           
  def changeEvent(self, e):
    if e.type() == QEvent.ActivationChange:
      pass
#      self.updateMiniatures()
      #print "stao sie"

if __name__ == '__main__':  
  app = QApplication(sys.argv)
  
  mai = Main(4)
  sys.exit(app.exec_())
