#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <glib.h>
#include <mce/dbus-names.h>
#include <libosso.h>
#include <stdlib.h>
#include <assert.h>
#include <libosso-abook/osso-abook.h>
#include <hal/libhal.h>
#include <sqlite3.h>


#include "maenotify.h"
#include "marshal.h"

static void
mark_as_read(gpointer data, gpointer user_data)
{
	sqlite3_stmt *rest;
	
	if ( sqlite3_prepare(db, g_strdup_printf("UPDATE Events SET is_read=1 WHERE id=%d",(gint)data), -1, &rest, NULL) == SQLITE_OK ) {
		if ( sqlite3_step(rest) == SQLITE_DONE ) printf("update ok\n");
		else printf("update fails\n");
	} else printf("prepare fails\n");
}
static void
aggregator_ready_cb (OssoABookWaitable *aggregator,
		const GError      *error,
		gpointer           user_data)
{
	(void) g_print("update abook status to ready\n");
	ab_ready = TRUE;
	
	aggr = OSSO_ABOOK_AGGREGATOR(aggregator);
}

static void 
received_sms_cb (DBusGProxy *the_proxy, char **ex)
{
	(void) g_print("received_sms cb on %s\n",current_lock);
	if ( g_strcmp0(current_lock,"locked") == 0 ) {
		get_counters(get_timestamp(0),get_timestamp(1));
		update_info(NULL);
	}
}


static void 
dbus_handle_mce_message(DBusGProxy *object G_GNUC_UNUSED, const gchar *mode, const gchar *blah G_GNUC_UNUSED, gpointer user_data G_GNUC_UNUSED)
{
	(void) g_print ("lock change: %s\n", mode);

	if ( g_strcmp0(mode,"unlocked") == 0 ) 
	{
		g_source_remove (to);
		if ( g_slist_length ( items_to_remove ) > 0 ) 
			g_slist_foreach ( items_to_remove, mark_as_read, NULL );
			
		items_to_remove = NULL;
	}
		
	if ( g_strcmp0(mode,"locked") == 0 && g_strcmp0(current_lock,"unlocked") == 0 ) 
	{
		update_info(NULL);
		current_lock = g_strdup(mode);
		to = gdk_threads_add_timeout ( 60000, update_info, NULL );
	} else current_lock = g_strdup(mode);
}


int main ( int argc, char *argv[] )
{
	g_print("start!\n");

	GError *error = NULL;
	DBusGConnection *sms_conn;
	DBusGProxy *proxy;
	DBusGProxy *sms_proxy;
	GMainLoop *loop = NULL;

	g_type_init ();
	
	osso_abook_init (&argc, &argv, NULL);
	
	ab_ready = FALSE;
	
	osso_abook_waitable_call_when_ready ( OSSO_ABOOK_WAITABLE (osso_abook_aggregator_get_default (NULL)), aggregator_ready_cb, NULL, NULL);

	connection = dbus_g_bus_get (DBUS_BUS_SYSTEM, &error);
	if (!connection) {
		g_printerr ("Failed to open connection to system bus: %s\n", error->message);
		g_clear_error (&error);
		return -1;
	} 
	
	sms_conn = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
	if ( !sms_conn ) {
		g_printerr ("Failed to open connection to session bus: %s\n", error->message);
		g_clear_error (&error);
		return -1;
	}

	if ( connection == NULL ) 
		g_print("con fails\n");

	if ( sms_conn == NULL )
		g_print("scon fails\n");
	
	proxy = dbus_g_proxy_new_for_name (connection, MCE_SERVICE, MCE_SIGNAL_PATH, MCE_SIGNAL_IF);
	if (!proxy) {
		g_print("proxy fails \n");
		return -1;
	}

	sms_proxy = dbus_g_proxy_new_for_name (sms_conn, DBUS_SERVICE_SMS, DBUS_PATH_SMS, DBUS_INTERFACE_SMS);
	if (!sms_proxy) {
		g_print("sms proxy fails \n");
		return -1;
	}

	/* hal init for battery status */
	if( ( ctx = libhal_ctx_new() ) == NULL)
        {
                printf("cannot create hal ctx\n");
                return -1;
        }
        //else printf("Hal ctx created\n");

        // Setup connection to D-BUS
        if( !libhal_ctx_set_dbus_connection( ctx, dbus_bus_get(DBUS_BUS_SYSTEM, &error) ) )
        {
                printf("cannot set dbus connection\n");
                dbus_error_free(&error);
                return -1;
        }
        //else printf("Connected to DBus\n");

        // Initialize libhal
        if( !libhal_ctx_init(ctx,&error) )
        {
                printf("cannot init libhal ctx\n");
                dbus_error_free(&error);
                return -1;
        }
	
	cpixbuf = gdk_pixbuf_new_from_file(CALL_ICO,NULL);		
	spixbuf = gdk_pixbuf_new_from_file(SMS_ICO, NULL);

	desc = pango_font_description_new ();
	pango_font_description_set_family_static (desc,"Georgia");
	pango_font_description_set_weight (desc, PANGO_WEIGHT_BOLD);
	pango_font_description_set_absolute_size (desc, 22 * PANGO_SCALE);
	
	if ( !g_file_test ( BASE_PATH, G_FILE_TEST_IS_DIR ) )
		system("/bin/mkdir /home/user/.maenotify");
		
	int rc;
	rc = sqlite3_open(EVENTS_DB, &db);
	
	items_to_remove = NULL;
//	if ( rc ) sqlite3_close(db);

/*		
	if ( !g_file_test ( g_strdup_printf("%s/%s",BASE_PATH,BASE_IMG), G_FILE_TEST_EXISTS ) )
		system("/bin/cp /etc/hildon/theme/backgrounds/lockslider.png /home/user/.maenotify/");
*/	
	
	loop = g_main_loop_new (NULL, FALSE);
	if ( loop == NULL ) 
		g_print("loop fails\n");
	
	dbus_g_object_register_marshaller (marshal_VOID__BOXED, G_TYPE_NONE, G_TYPE_STRV, G_TYPE_INVALID);
	dbus_g_proxy_add_signal (sms_proxy, "MessagesExpunged", G_TYPE_STRV, G_TYPE_INVALID );
	dbus_g_proxy_connect_signal (sms_proxy, "MessagesExpunged", G_CALLBACK(received_sms_cb), sms_conn, NULL);
	
	dbus_g_proxy_add_signal (proxy, MCE_TKLOCK_MODE_SIG, G_TYPE_STRING , G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (proxy, MCE_TKLOCK_MODE_SIG, G_CALLBACK (dbus_handle_mce_message), NULL, NULL);
	
	current_lock = "unlocked";
	//get_counters(get_timestamp(0),get_timestamp(1));
	
	g_print("loop start\n");
	g_main_loop_run(loop);

  	dbus_g_proxy_disconnect_signal (proxy, MCE_TKLOCK_MODE_SIG, G_CALLBACK (dbus_handle_mce_message), NULL);
  	dbus_g_proxy_disconnect_signal (sms_proxy, "MessagesExpugned", G_CALLBACK(received_sms_cb), NULL);
  
	g_object_unref (proxy);
	g_object_unref (sms_proxy);
	dbus_g_connection_flush (connection);
	dbus_g_connection_unref (connection);
	sqlite3_close(db);

	return 0;

}
