# -*- coding: utf-8 -*-

import math
from PyQt4 import QtCore, QtGui



class Lux_Stenope(QtGui.QWidget):


    
    

    def setLux(self):
        lux = self.getLux()
        if lux == "0":
            tps = "LUX = 0!"
        else:
            ev , r = self.Lux2EV(int(lux))
            self.t = (self.f**2)*250./(self.ISO * int(lux))
            if self.t < 1 and self.t !=0:
                self.t = 1 / self.t
                if self.t >= 10:
                    tps = '1/' + str(int(self.t))+'s'
                else:
                    tps = '1/' + str(round(self.t,1))+'s'
            else:
                if self.t < 10 :
                    tps = str(round(self.t,1))+'s'
                elif self.t >= 60 and self.t < 3600:
                    s = int(self.t) % 60
                    m = int(self.t/60)
                    tps = str(m)+'mn '+str(s)+'s'
                elif self.t >= 3600:
                    s = int(self.t) % 60
                    m = int(self.t/60) % 60
                    h = int(self.t/3600)
                    tps = str(h)+'h '+str(m)+'mn'
                else:
                    tps = str(int(self.t))+'s'
                    

#            self.Lux.setText(lux+' Lux \n'+ str(ev) + ' EV\n'+tps)
            self.Lux.setText(lux)
            if r == 0:
                self.EV.setText(str(ev))
            else:
                self.EV.setText(str(ev) +' '+ str(r)+'/3')
            self.Temps.setText(tps)

    def Lux2EV(self,lux):

# avoid negative EV value
        if lux < 1 : 
            lux = 1;

        ev = math.log(lux * self.ISO / 250.,2)
    
        q = int(ev)
    
        r = int((ev-q)*3)
    
        return q , r


    def getLux(self):
    
        fichier = open('/sys/class/i2c-adapter/i2c-2/2-0029/lux', 'r')

        return fichier.read().replace('\n','')
        
    def clap(self):
        if self.ClapButton.isChecked():
            self.timer.stop()
            
            self.ClapButton.setText("Reprendre")
        else:
            self.timer.start(50)
            self.ClapButton.setText("Fixer")
            
    def set_f(self,value):
        self.f = value

    def set_ISO(self,value):
        self.ISO = value

    def __init__(self, parent=None):
        super(Lux_Stenope, self).__init__(parent)
        self.ISO = 8.
    
        self.f = 280.
        
        self.t = 0

        font = QtGui.QFont()
        font.setPointSize(64)

#        LuxMeter.setWindowTitle("LuxMeter")
#        LuxMeter.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)
#        self.centralwidget = QtGui.QWidget(LuxMeter)
#        self.centralwidget.setGeometry(QtCore.QRect(0, 0, 800, 400))

        self.gridLayout = QtGui.QGridLayout(self)

        
        self.EV_Label = QtGui.QLabel(self)
        self.EV_Label.setFont(font)
        self.EV_Label.setText("EV")
        self.EV_Label.setAlignment(QtCore.Qt.AlignCenter)
        self.gridLayout.addWidget(self.EV_Label, 1, 1, 1, 1)
        
        self.Lux_Label = QtGui.QLabel(self)
        self.Lux_Label.setFont(font)
        self.Lux_Label.setText("Lux")
        self.Lux_Label.setAlignment(QtCore.Qt.AlignCenter)
        self.gridLayout.addWidget(self.Lux_Label, 1, 0, 1, 1)
        
        self.Lux = QtGui.QLabel(self)
        self.Lux.setFont(font)
        self.Lux.setAlignment(QtCore.Qt.AlignCenter)
        self.gridLayout.addWidget(self.Lux, 0, 0, 1, 1)
        
        self.EV = QtGui.QLabel(self)
        self.EV.setFont(font)
        self.EV.setAlignment(QtCore.Qt.AlignCenter)
        self.EV.setObjectName("EV")
        self.gridLayout.addWidget(self.EV, 0, 1, 1, 1)
        
        self.Temps = QtGui.QLabel(self)
        self.Temps.setFont(font)
        self.Temps.setAlignment(QtCore.Qt.AlignCenter)
        self.Temps.setObjectName("Temps")
        self.gridLayout.addWidget(self.Temps, 3, 0, 1, 2)
        
        self.Temps_Label = QtGui.QLabel(self)
        font = QtGui.QFont()
        font.setPointSize(24)
        self.Temps_Label.setFont(font)
        self.Temps_Label.setText("Temps de pose :")
        self.Temps_Label.setAlignment(QtCore.Qt.AlignCenter)
        self.gridLayout.addWidget(self.Temps_Label, 2, 0, 1, 2)
        
        self.ClapButton = QtGui.QPushButton(self)
        self.ClapButton.setFont(font)
        self.ClapButton.setCheckable(True)
        self.ClapButton.setChecked(True)
        self.ClapButton.setText("D\xe9marrer")
        self.gridLayout.addWidget(self.ClapButton, 4, 0, 1, 2)
        
#        LuxMeter.setCentralWidget(self.centralwidget)

#        self.ISO , ok = QtGui.QInputDialog.getInteger ( self.centralwidget, "Sensibilit\xe9", "Entrer la sensibilit\xe8 ISO du medium", 10, 0,  2147483647, 1) 
#        self.f , ok = QtGui.QInputDialog.getInteger ( self.centralwidget, "Ouverture", "Entrer le nombre f de l'ouverture", 250, 0,  2147483647, 1)
        
        self.timer =  QtCore.QTimer(self)
        
        QtCore.QObject.connect( self.timer, QtCore.SIGNAL("timeout()"), self.setLux )    
        self.ClapButton.clicked.connect(self.clap) 
#        self.timer.start(50)

