# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'compteur.ui'
#
# Created: Sun Aug  1 15:09:10 2010
#      by: PyQt4 UI code generator 4.7.2
#
# WARNING! All changes made in this file will be lost!

from PyQt4 import QtCore, QtGui
import math
import time
import dbus

class AigSeconde(QtGui.QWidget):
    def __init__(self, parent=None):
        super(AigSeconde, self).__init__(parent)

        self.penColor = QtGui.QColor(255,0,0)
        self.penWidth = 4
        self.value = 0
        self.x = 218.
        self.y = 254.
        

    def minimumSizeHint(self):
        return QtCore.QSize(50, 50)

    def sizeHint(self):
        return QtCore.QSize(800, 800)

    def setValue(self, value):
        self.value = value

        self.path = QtGui.QPainterPath()
        self.path.moveTo(self.x,self.y)
        self.path.lineTo(self.x + 150. * math.cos( (self.value % 60) / 30. * math.pi - math.pi / 2.),self.y + 150. * math.sin( (self.value % 60) / 30. * math. pi - math.pi / 2.))

        self.update()
        
    def setCenter(self,x,y):
        self.x = x
        self.y = y
        self.setValue(self.value)
        
    def paintEvent(self, event):
        painter = QtGui.QPainter(self)
        painter.setRenderHint(QtGui.QPainter.Antialiasing)
        painter.setPen(QtGui.QPen(self.penColor,self.penWidth,QtCore.Qt.SolidLine, QtCore.Qt.FlatCap, QtCore.Qt.RoundJoin))
        painter.drawPath(self.path)

class AigMin(QtGui.QWidget):
    def __init__(self, parent=None):
        super(AigMin, self).__init__(parent)

        self.penColor = QtGui.QColor(255,255,255)
        self.penWidth = 7
        self.value = 0
        self.x = 218.
        self.y = 254.
        
    def minimumSizeHint(self):
        return QtCore.QSize(50, 50)

    def sizeHint(self):
        return QtCore.QSize(400, 400)

    def setValue(self, value):
        self.value = value

        self.path = QtGui.QPainterPath()
        self.path.moveTo(self.x,self.y)
        self.path.lineTo(self.x + 130. * math.cos( (self.value % 60) / 30. * math.pi - math.pi / 2.),self.y + 130. * math.sin( (self.value % 60) / 30. * math. pi - math.pi / 2.))

        self.update()
        
    def setCenter(self,x,y):
        self.x = x
        self.y = y
        self.setValue(self.value)

    def paintEvent(self, event):
        painter = QtGui.QPainter(self)
        painter.setRenderHint(QtGui.QPainter.Antialiasing)
        painter.setPen(QtGui.QPen(self.penColor,self.penWidth,QtCore.Qt.SolidLine, QtCore.Qt.FlatCap, QtCore.Qt.RoundJoin))
        painter.drawPath(self.path)

class AigHeure(QtGui.QWidget):
    def __init__(self, parent=None):
        super(AigHeure, self).__init__(parent)

        self.penColor = QtGui.QColor(255,255,255)
        self.penWidth = 10
        self.value = 0
        self.x = 218.
        self.y = 254.
        
    def minimumSizeHint(self):
        return QtCore.QSize(50, 50)

    def sizeHint(self):
        return QtCore.QSize(400, 400)

    def setValue(self, value):
        self.value = value
        
        self.path = QtGui.QPainterPath()
        self.path.moveTo(self.x,self.y)
        self.path.lineTo(self.x + 90. * math.cos( (self.value % 12) / 6. * math.pi - math.pi / 2.),self.y + 90. * math.sin( (self.value % 12) / 6. * math. pi - math.pi / 2.))
        
        self.update()
        
    def setCenter(self,x,y):
        self.x = x
        self.y = y
        self.setValue(self.value)

    def paintEvent(self, event):
        painter = QtGui.QPainter(self)
        painter.setRenderHint(QtGui.QPainter.Antialiasing)
        painter.setPen(QtGui.QPen(self.penColor,self.penWidth,QtCore.Qt.SolidLine, QtCore.Qt.FlatCap, QtCore.Qt.RoundJoin))
        painter.drawPath(self.path)
        

class Compteur_Stenope(QtGui.QWidget):

    def event_Filter(self, object, event):
        if event.type() == QtCore.QEvent.MouseButtonPress:
            object.emit(QtCore.SIGNAL("clicked()"))
            return 1
        elif event.type() == QtCore.QEvent.MouseButtonRelease:
            object.emit(QtCore.SIGNAL("released()"))
            return 1
        elif event.type() == QtCore.QEvent.Enter:
            object.emit(QtCore.SIGNAL("enter()"))
            return 1
        else:
            return 0

    def setLCD(self,num):
        self.lcdNumber_S.display(num % 60)
        self.lcdNumber_M.display((num/60) % 60)
        self.lcdNumber_H.display(min(num / 3600,99))

    def setAig(self,num):
        self.heure.setValue(num / 3600)
        self.min.setValue(num / 60)
        self.sec.setValue(num)
        self.Clock_Edit.setValue( (num +30) % 60 )
        
    def time(self):
        if self.temps > 1:
            self.temps += -1
            self.setAig(self.temps)
            self.setLCD(self.temps)
            
        elif self.temps == 1:
            if self.lcdNumber_S.styleSheet() != "color : red;":
                self.lcdNumber_S.setStyleSheet("color : red;")
                self.lcdNumber_M.setStyleSheet("color : red;")
                self.lcdNumber_H.setStyleSheet("color : red;")
                self.label_S.setStyleSheet("color : red;")
                self.label_M.setStyleSheet("color : red;")
                self.label_H.setStyleSheet("color : red;")
            dbus.Interface(dbus.Bus.get_system().get_object("com.nokia.mce","/com/nokia/mce/request"),"com.nokia.mce.request").req_vibrator_pattern_activate("PatternIncomingCall")
            self.temps += -1
            self.setAig(self.temps)
            self.setLCD(-self.temps)
            
        else:   
            self.temps += -1
#            self.setAig(-self.temps)
            self.setLCD(-self.temps)

#            self.timer.stop()
            
    def clap(self):
        if self.ClapButton.isChecked():
            if self.temps > 0:
                self.temps = self.temps_ini
            self.timer.start(1000)
        else:
            self.timer.stop()
            dbus.Interface(dbus.Bus.get_system().get_object("com.nokia.mce","/com/nokia/mce/request"),"com.nokia.mce.request").req_vibrator_pattern_deactivate("PatternIncomingCall")
            


    def reset(self):
        self.ClapButton.setChecked(False)
        self.temps = self.temps_ini
        self.setLCD(self.temps)
        self.setAig(self.temps)
        self.lcdNumber_S.setStyleSheet("")
        self.lcdNumber_M.setStyleSheet("")
        self.lcdNumber_H.setStyleSheet("")
        self.label_S.setStyleSheet("")
        self.label_M.setStyleSheet("")
        self.label_H.setStyleSheet("")
        self.timer.stop()
        dbus.Interface(dbus.Bus.get_system().get_object("com.nokia.mce","/com/nokia/mce/request"),"com.nokia.mce.request").req_vibrator_pattern_deactivate("PatternIncomingCall")

    def Change_H(self):
        self.lcdNumber_H.setStyleSheet("color : black; background-color : white;")
        H , ok = QtGui.QInputDialog.getInteger ( self, "Temps de Pose", "Entrer la dur\xe9e en heure", self.lcdNumber_H.intValue(), 0,  2147483647, 1)
        self.setLCD(H*3600 + self.lcdNumber_M.intValue()*60 + self.lcdNumber_S.intValue())
        self.setAig(H*3600 + self.lcdNumber_M.intValue()*60 + self.lcdNumber_S.intValue())
        self.temps_ini = self.lcdNumber_H.intValue()*3600 + self.lcdNumber_M.intValue()*60 + self.lcdNumber_S.intValue()
        self.lcdNumber_H.setStyleSheet("")

    def Change_M(self):
        self.lcdNumber_M.setStyleSheet("color : black; background-color : white;")
        M , ok = QtGui.QInputDialog.getInteger ( self, "Temps de Pose", "Entrer la dur\xe9e en minute", self.lcdNumber_M.intValue(), 0,  2147483647, 1)
        self.setLCD(M*60 + self.lcdNumber_H.intValue()*3600 + self.lcdNumber_S.intValue())
        self.setAig(M*60 + self.lcdNumber_H.intValue()*3600 + self.lcdNumber_S.intValue())
        self.temps_ini = self.lcdNumber_H.intValue()*3600 + self.lcdNumber_M.intValue()*60 + self.lcdNumber_S.intValue()
        self.lcdNumber_M.setStyleSheet("")

    def Change_S(self):
        self.lcdNumber_S.setStyleSheet("color : black; background-color : white;")
        S , ok = QtGui.QInputDialog.getInteger ( self, "Temps de Pose", "Entrer la dur\xe9e en seconde", self.lcdNumber_S.intValue(), 0,  2147483647, 1)
        self.setLCD(S + self.lcdNumber_H.intValue()*3600 + self.lcdNumber_M.intValue()*60)
        self.setAig(S + self.lcdNumber_H.intValue()*3600 + self.lcdNumber_M.intValue()*60)
        self.temps_ini = self.lcdNumber_H.intValue()*3600 + self.lcdNumber_M.intValue()*60 + self.lcdNumber_S.intValue()
        self.lcdNumber_S.setStyleSheet("")

    def Clock_Edit_Pressed(self):
        self.timer_pressed = QtCore.QTimer(self)
        QtCore.QObject.connect( self.timer_pressed, QtCore.SIGNAL("timeout()"), self.Clock_Edit_Actif)  
        self.timer_pressed.start(1200)

    def Clock_Edit_Released(self):
        self.timer_pressed.stop()

    def Clock_Edit_Actif(self):
        self.Clock_Edit.show()
        self.Clock.hide()
        self.ClapButton.hide()
        self.OkButton.show()

    def Clock_Edit_Desactif(self):
        self.Clock_Edit.hide()
        self.Clock.show()
        self.ClapButton.show()
        self.OkButton.hide()
        self.temps_ini = self.lcdNumber_H.intValue()*3600 + self.lcdNumber_M.intValue()*60 + self.lcdNumber_S.intValue()
        self.reset()

    def Finger_Clock(self,value):

        if (value + 30) % 60 == 0 :
        
            if self.lcdNumber_S.intValue() > 30:
            
                if self.lcdNumber_M.intValue() == 59:
                    self.lcdNumber_M.display(0)
                    self.lcdNumber_H.display((self.lcdNumber_H.intValue() + 1) % 100)
                else:
                    self.lcdNumber_M.display(self.lcdNumber_M.intValue() + 1)
                
            elif self.lcdNumber_S.intValue() < 30:
            
                if self.lcdNumber_M.intValue() == 0:
                    self.lcdNumber_M.display(59)
                    if self.lcdNumber_H.intValue() != 0:
                        self.lcdNumber_H.display(max(self.lcdNumber_H.intValue() - 1,0))
                    else:
                        self.lcdNumber_H.display(99)
                else:
                    self.lcdNumber_M.display(max(self.lcdNumber_M.intValue() - 1,0))
        self.lcdNumber_S.display((value + 30) % 60)
        
    def orientationChanged(self):
        screenGeometry = self.app.desktop().screenGeometry()
        if screenGeometry.width() < screenGeometry.height():
#            print "Portrait_Compteur"
            for widget in [self.Clock,self.lcdNumber_H,self.lcdNumber_M,self.lcdNumber_S,self.label_H,self.label_M,self.label_S,self.ClapButton,self.ResetButton,self.heure,self.min,self.sec]:
                self.gridLayout.removeWidget(widget)
            self.gridLayout.addWidget(self.Clock, 0, 0, 1, 6)
            self.gridLayout.addWidget(self.heure, 0, 0, 1, 6)
            self.gridLayout.addWidget(self.min, 0, 0, 1, 6)
            self.gridLayout.addWidget(self.sec, 0, 0, 1, 6)
            self.gridLayout.addWidget(self.Clock_Edit, 0, 0, 1, 6)
            self.gridLayout.addWidget(self.lcdNumber_H, 1, 0)
            self.gridLayout.addWidget(self.label_H, 1, 1)
            self.gridLayout.addWidget(self.lcdNumber_M, 1, 2)
            self.gridLayout.addWidget(self.label_M, 1, 3)
            self.gridLayout.addWidget(self.lcdNumber_S, 1, 4)
            self.gridLayout.addWidget(self.label_S, 1, 5)
            self.gridLayout.addWidget(self.ResetButton, 2, 0, 1, 6)
            self.gridLayout.addWidget(self.ClapButton, 3, 0, 1, 6)
            self.gridLayout.addWidget(self.OkButton, 3, 0, 1, 6)
            self.heure.setCenter(218., 254.)
            self.min.setCenter(218., 254.)
            self.sec.setCenter(218., 254.)
            

        else:
#            print "Paysage_Compteur"
            for widget in [self.Clock,self.lcdNumber_H,self.lcdNumber_M,self.lcdNumber_S,self.label_H,self.label_M,self.label_S,self.ClapButton,self.ResetButton,self.heure,self.min,self.sec]:
                self.gridLayout.removeWidget(widget)
            self.gridLayout.addWidget(self.Clock, 0, 0, 5, 1)
            self.gridLayout.addWidget(self.heure, 0, 0, 5, 1)
            self.gridLayout.addWidget(self.min, 0, 0, 5, 1)
            self.gridLayout.addWidget(self.sec, 0, 0, 5, 1)
            self.gridLayout.addWidget(self.Clock_Edit, 0, 0, 5, 1)
            self.gridLayout.addWidget(self.lcdNumber_H, 0, 1)
            self.gridLayout.addWidget(self.label_H, 0, 2)
            self.gridLayout.addWidget(self.lcdNumber_M, 1, 1)
            self.gridLayout.addWidget(self.label_M, 1, 2)
            self.gridLayout.addWidget(self.lcdNumber_S, 2, 1)
            self.gridLayout.addWidget(self.label_S, 2, 2)
            self.gridLayout.addWidget(self.ResetButton, 3, 1,1,2)
            self.gridLayout.addWidget(self.ClapButton, 4, 1,1,2)
            self.gridLayout.addWidget(self.OkButton, 4, 1,1,2)
            self.heure.setCenter(318., 200.)
            self.min.setCenter(318., 200.)
            self.sec.setCenter(318., 200.)


    def __init__(self, app, parent=None):
        super(Compteur_Stenope, self).__init__(parent)
        self.app = app
#        MainWindow.setWindowTitle("Compteur")
#        MainWindow.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)
        self.temps_ini = 00
        self.temps = 00
        
        font = QtGui.QFont()
        font.setPointSize(32)

        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)

        
#        self.layoutWidget = QtGui.QWidget(MainWindow)
#        self.layoutWidget.setGeometry(QtCore.QRect(0, 0, 800, 400))

        self.gridLayout = QtGui.QGridLayout(self)
#        self.gridLayout.setVerticalSpacing(32)

        self.Clock = QtGui.QLabel(self)
        self.Clock.setPixmap(QtGui.QPixmap("/home/user/expometre/clock-face.png"))
        self.Clock.setAlignment(QtCore.Qt.AlignCenter)



        self.lcdNumber_H = QtGui.QLCDNumber(self)
        self.lcdNumber_H.setFrameShape(QtGui.QFrame.NoFrame)
        self.lcdNumber_H.setNumDigits(2)

        
        self.lcdNumber_M = QtGui.QLCDNumber(self)
        self.lcdNumber_M.setFrameShape(QtGui.QFrame.NoFrame)
        self.lcdNumber_M.setNumDigits(2)

        
        self.lcdNumber_S = QtGui.QLCDNumber(self)
        self.lcdNumber_S.setFrameShape(QtGui.QFrame.NoFrame)
        self.lcdNumber_S.setNumDigits(2)

        
        self.label_H = QtGui.QLabel(self)
        self.label_H.setSizePolicy(sizePolicy)
        self.label_H.setFont(font)
        self.label_H.setText("h")

        
        self.label_M = QtGui.QLabel(self)
        self.label_M.setSizePolicy(sizePolicy)
        self.label_M.setFont(font)
        self.label_M.setText("m")


        self.label_S = QtGui.QLabel(self)
        self.label_S.setSizePolicy(sizePolicy)
        self.label_S.setFont(font)
        self.label_S.setText("s")

        
        self.ResetButton = QtGui.QPushButton(self)
        self.ResetButton.setFont(font)
        self.ResetButton.setText("Reset")


        self.ClapButton = QtGui.QPushButton(self)
        self.ClapButton.setFont(font)
        self.ClapButton.setCheckable(True)
        self.ClapButton.setText("Clap!")


        self.OkButton = QtGui.QPushButton(self)
        self.OkButton.setFont(font)
        self.OkButton.setText("Ok")
        self.OkButton.hide()

        self.heure = AigHeure(self)


        self.min = AigMin(self)

        
        self.sec = AigSeconde(self)


        self.Clock_Edit = QtGui.QDial(self)
        self.Clock_Edit.setWrapping(True)
        self.Clock_Edit.setNotchesVisible(True)
        self.Clock_Edit.setMaximum(59)
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Preferred)
        self.Clock_Edit.setSizePolicy(sizePolicy)

        self.Clock_Edit.setValue(30)
        self.Clock_Edit.hide()

        self.timer =  QtCore.QTimer(self)
        self.reset()
        self.orientationChanged()

        parent.eventFilter = self.event_Filter

        self.lcdNumber_H.installEventFilter(parent)
        QtCore.QObject.connect(self.lcdNumber_H,QtCore.SIGNAL("clicked()"),self.Change_H)
        self.lcdNumber_M.installEventFilter(parent)
        QtCore.QObject.connect(self.lcdNumber_M,QtCore.SIGNAL("clicked()"),self.Change_M)
        self.lcdNumber_S.installEventFilter(parent)
        QtCore.QObject.connect(self.lcdNumber_S,QtCore.SIGNAL("clicked()"),self.Change_S)
        self.sec.installEventFilter(parent)
        QtCore.QObject.connect(self.sec,QtCore.SIGNAL("clicked()"),self.Clock_Edit_Pressed)
        QtCore.QObject.connect(self.sec,QtCore.SIGNAL("released()"),self.Clock_Edit_Released)
        QtCore.QObject.connect(self.Clock_Edit, QtCore.SIGNAL("valueChanged(int)"), self.Finger_Clock)
        self.OkButton.clicked.connect(self.Clock_Edit_Desactif) 
        
        QtCore.QObject.connect( self.timer, QtCore.SIGNAL("timeout()"), self.time)  
  
        self.ClapButton.clicked.connect(self.clap) 
        self.ResetButton.clicked.connect(self.reset) 

        QtCore.QObject.connect(app.desktop(), QtCore.SIGNAL("resized(int)"), self.orientationChanged);

#        MainWindow.setCentralWidget(self.layoutWidget)


