
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow() :
  pickerbutton_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH |
    Gtk::Hildon::SIZE_FINGER_HEIGHT, Hildon::BUTTON_ARRANGEMENT_VERTICAL)
{
  set_title("Hildon::TouchSelectorEntry Example");

  // Create TreeModels and add TouchSelectorColumns to show them:
  Glib::RefPtr<Gtk::ListStore> name_store = 
    Gtk::ListStore::create(name_columns_);
  Glib::RefPtr<Hildon::TouchSelectorColumn> name_column =
    touchselector_.append_text_column(name_store);
  name_column->set_property("text-column", 0); // TODO: Add a TextSelectorColumn::set_text_column() method?

  Glib::RefPtr<Gtk::ListStore> surname_store = 
    Gtk::ListStore::create(surname_columns_);
  Glib::RefPtr<Hildon::TouchSelectorColumn> surname_column =
    touchselector_.append_text_column(surname_store);
  surname_column->set_property("text-column", 0);

  // Populate the name and surname columns.
  Gtk::TreeModel::Row row = *(name_store->append());
  row[name_columns_.name_] = "Alice";
  row = *(name_store->append());
  row[name_columns_.name_] = "Bob";
  row = *(name_store->append());
  row[name_columns_.name_] = "Jane";
  row = *(name_store->append());
  row[name_columns_.name_] = "John";
  row = *(name_store->append());
  row[name_columns_.name_] = "Peter";
  row = *(name_store->append());
  row[name_columns_.name_] = "Sally";
  row = *(name_store->append());
  row[name_columns_.name_] = "Simon";
  row = *(surname_store->append());
  row[surname_columns_.surname_] = "Brown";
  row = *(surname_store->append());
  row[surname_columns_.surname_] = "Jennings";
  row = *(surname_store->append());
  row[surname_columns_.surname_] = "Johnson";
  row = *(surname_store->append());
  row[surname_columns_.surname_] = "King";
  row = *(surname_store->append());
  row[surname_columns_.surname_] = "Matthews";
  row = *(surname_store->append());
  row[surname_columns_.surname_] = "Parker";
  row = *(surname_store->append());
  row[surname_columns_.surname_] = "White";
  
  pickerbutton_.set_selector(touchselector_);
  pickerbutton_.set_title("Select a Name");

  box_.add(pickerbutton_);
  add(box_);

  pickerbutton_.signal_value_changed().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_value_changed));

  //Set a callback function to build a text representation of the 
  //selected item for the picker button:
  touchselector_.set_print_func(
    sigc::mem_fun(*this, &ExampleWindow::picker_button_print_func));

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_value_changed()
{
  std::cout << "Selection changed. Current state=" <<
    touchselector_.get_current_text() << std::endl;
}

// Combine strings in TouchSelector, adding space between each string.
Glib::ustring ExampleWindow::picker_button_print_func()
{
//  Gtk::TreeModel::iterator iter = touchselector_.get_selected(0);
//  Gtk::TreeModel::Row row = *iter;
//  Glib::ustring name = row[name_columns_.name_];

  Gtk::TreeModel::iterator iter = touchselector_.get_selected(1);
  Gtk::TreeModel::Row row = *iter;
  Glib::ustring surname = row[surname_columns_.surname_];
  
  return touchselector_.get_entry()->get_text() + " " + surname;
}
