
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <hildonmm.h>
#include <hildon-notifymm.h>
#include <hildon/hildon-notification.h>
#include <libnotifymm/init.h>
#include <gtkmm/stock.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <iostream>

void on_button_show_notification()
{
  // Create a new notification:
  Glib::RefPtr<Hildon::Notification> notification = 
    Hildon::Notification::create("Something Happened", 
      "A thing has just happened.", 
      Gtk::Stock::OPEN);

  // Show the notification:
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
    notification->show();
  }
  catch(const Glib::Error& ex)
  {
    std::cerr << "Notification::show() failed: " << ex.what() << std::endl;
  }
#else
  std::auto_ptr<Glib::Error> ex;
  notification->show(ex);
  if(ex.get())
  { 
    std::cerr << "Notification::show() failed: " << ex->what() << std::endl;
  }
#endif //GLIBMM_EXCEPTIONS_ENABLED
}

int main(int argc, char *argv[])
{
  // Initialize gtkmm and maemomm:
  Gtk::Main kit(&argc, &argv);
  Hildon::init();
  Hildon::notify_init("Notification Example");

  // Initialize D-Bus (needed by hildon-notify):
  DBusConnection* conn = dbus_bus_get(DBUS_BUS_SESSION, NULL);
  dbus_connection_setup_with_g_main(conn, NULL);

  // Show a window with a button:
  Hildon::Window window;
  window.set_title("Hildon::Notification Example");
  Hildon::Program::get_instance()->add_window(window);

  Gtk::VButtonBox box;
  Hildon::Button button(
    Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
     "To show a notification");
  box.pack_start(button);
  window.add(box);
  box.show_all();

  // Show the notification when the button is clicked:
  button.signal_clicked().connect(sigc::ptr_fun(&on_button_show_notification));
  
  // Begin the application
  kit.run(window);
  
  return 0;
}
