
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _MAEMOMM_EXAMPLEWINDOW_H
#define _MAEMOMM_EXAMPLEWINDOW_H

#include <hildonmm/window.h>
#include <gtkmm.h>

class ExampleWindow : public Hildon::Window
{
public:
  ExampleWindow();
  virtual ~ExampleWindow();

private:
  // Signal handlers:
  void on_menu_radio1();
  void on_menu_radio2();
  void on_menu_check();
  void on_menu_close();

  // Child widgets:
  Gtk::Menu main_;
  Gtk::Menu sub_others_;

  Gtk::MenuItem item_others_;
  Gtk::RadioMenuItem::Group group_;
  Gtk::RadioMenuItem item_radio1_;
  Gtk::RadioMenuItem item_radio2_;

  Gtk::CheckMenuItem item_check_;
  Gtk::CheckMenuItem item_close_;
  Gtk::SeparatorMenuItem item_separator_;
};

#endif /* _MAEMOMM_EXAMPLEWINDOW_H */
