
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow()
{
  set_title("UIManager Example");

  // Create actions for menus and toolbars:
  actiongroup_ = Gtk::ActionGroup::create();

  // File|New sub menu:
  actiongroup_->add(Gtk::Action::create("FileNewStandard", Gtk::Stock::NEW,
    "_New", "Create a new file"),
    sigc::mem_fun(*this, &ExampleWindow::on_action_file_new));

  actiongroup_->add(Gtk::Action::create("FileNewFoo", Gtk::Stock::NEW,
    "New Foo", "Create a new foo"),
    sigc::mem_fun(*this, &ExampleWindow::on_action_file_new));

  actiongroup_->add(Gtk::Action::create("FileNewGoo", Gtk::Stock::NEW, "_New Goo", "Create a new goo"),
    sigc::mem_fun(*this, &ExampleWindow::on_action_file_new));

  // File menu:
  actiongroup_->add(Gtk::Action::create("FileMenu", "File"));
  // Sub-menu.
  actiongroup_->add(Gtk::Action::create("FileNew", Gtk::Stock::NEW));
  actiongroup_->add(Gtk::Action::create("FileQuit", Gtk::Stock::QUIT),
    sigc::mem_fun(*this, &ExampleWindow::on_action_file_quit));

  uimanager_ = Gtk::UIManager::create();
  uimanager_->insert_action_group(actiongroup_);
 
  add_accel_group(uimanager_->get_accel_group());

  /* Layout the actions in a menu and toolbar. In Hildon you have to use
   *  "popup" for the menu because you can only have one menu and cannot add
   *  a whole menubar. */
  
  Glib::ustring ui_info = 
        "<ui>"
        "    <popup action='FileMenu'>"
        "      <menu action='FileNew'>"
        "        <menuitem action='FileNewStandard'/>"
        "        <menuitem action='FileNewFoo'/>"
        "        <menuitem action='FileNewGoo'/>"
        "      </menu>"
        "      <separator/>"
        "      <menuitem action='FileQuit'/>"
        "    </popup>"
        "  <toolbar  name='ToolBar'>"
        "    <toolitem action='FileNewStandard'/>"
        "    <toolitem action='FileQuit'/>"
        "  </toolbar>"
        "</ui>";

  std::auto_ptr<Glib::Error> ex;
  uimanager_->add_ui_from_string(ui_info, ex);
  if(ex.get())
  { 
    std::cerr << "building menus failed: " <<  ex->what();
  }
 
  // Get the menu and toolbar widgets, and add them to a container widget:
  Gtk::Menu* menu =
    dynamic_cast<Gtk::Menu*>(uimanager_->get_widget("/FileMenu"));
  if(menu)
    set_main_menu(*menu);

  Gtk::Toolbar* toolbar =
    dynamic_cast<Gtk::Toolbar*>(uimanager_->get_widget("/ToolBar"));
  if(toolbar)
    add_toolbar(*toolbar);
  
  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_action_file_quit()
{
  hide(); // Closes the main window to stop the Gtk::Main::run().
}

void ExampleWindow::on_action_file_new()
{
   std::cout << "A File|New action was selected." << std::endl;
}

void ExampleWindow::on_action_others()
{
  std::cout << "An action was selected." << std::endl;
}

