
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <hildonmm/note.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  button_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me (three times)",
    "to show notes"),
  type_(1)
{    
  set_title("Hildon::Note Example");
  
  // Attach the callback functions to the clicked signal.
  button_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button));
  
  box_.pack_start(button_);
  add(box_);
  
  // Make all widgets visible.
  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button()
{
  switch (type_)
  {
    case 1:
    {
      Hildon::Note note(Hildon::NOTE_TYPE_INFORMATION,
        "Very important information. (click to dismiss)");
      note.run();
      break;
    }
    case 2:
    {
      Hildon::Note note(Hildon::NOTE_TYPE_CONFIRMATION_BUTTON, *this,
        "Do you agree?");
      note.add_button(Gtk::Stock::YES, Gtk::RESPONSE_YES);
      note.add_button(Gtk::Stock::NO, Gtk::RESPONSE_NO);
      
      note.run();
      break;
    }
    case 3:
    {
      Hildon::Note* note = new Hildon::Note(bar_, *this,
        "Note with ProgressBar");
      bar_.set_fraction(0.5);
      note->run();
      delete note;
    }
  }
  
  ++type_;
  if(type_ > 3)
     type_ = 1;
}
