/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include <hildonmm.h>
#include <hildon-notifymm.h>
#include <hildon/hildon-notification.h>
#include <libnotifymm/init.h>
#include <gtkmm/stock.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <iostream>

void on_button_show_notification()
{
  // Create a new notification:
  Glib::RefPtr<Hildon::Notification> notification = 
    Hildon::Notification::create("Something Happened", 
      "A thing has just happened.", 
      Gtk::Stock::OPEN);

  // Show the notification:
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
    notification->show();
  }
  catch(const Glib::Error& ex)
  {
    std::cerr << "Notification::show() failed: " << ex.what() << std::endl;
  }
#else
  std::auto_ptr<Glib::Error> ex;
  notification->show(ex);
  if(ex.get())
  { 
    std::cerr << "Notification::show() failed: " << ex->what() << std::endl;
  }
#endif //GLIBMM_EXCEPTIONS_ENABLED
}

int main(int argc, char *argv[])
{
  // Initialize gtkmm and maemomm:
  Gtk::Main kit(&argc, &argv);
  Hildon::init();
  Hildon::notify_init("Notification example");

  // Initialize D-Bus (needed by hildon-notify):
  DBusConnection* conn = dbus_bus_get(DBUS_BUS_SESSION, NULL);
  dbus_connection_setup_with_g_main(conn, NULL);

  // Show a window with a button:
  Hildon::Window window;
  window.set_title("Notification example");
  Hildon::Program::get_instance()->add_window(window);

  Gtk::VButtonBox box;
  Hildon::Button button(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
                        Hildon::BUTTON_ARRANGEMENT_VERTICAL,
                        "Click me!",
                        "to show a notification");
  box.pack_start(button);
  window.add(box);
  box.show_all();

  // Show the notification when the button is clicked:
  button.signal_clicked().connect(sigc::ptr_fun(&on_button_show_notification));
  
  // Begin the application
  kit.run(window);
  
  return 0;
}
