/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  item_others_("Others"),
  item_radio1_(group_, "Radio1"),
  item_radio2_(group_, "Radio2"),  
  item_check_("Check"),
  item_close_("Close")
{
  set_title("Menu example");

  // Add menu items to right menus.
  main_.append(item_others_);
  sub_others_.append(item_radio1_);
  sub_others_.append(item_radio2_);
  sub_others_.append(item_separator_);
  sub_others_.append(item_check_);
  main_.append(item_close_);
 
  // Add others submenu to the "Others" item.
  item_others_.set_submenu(sub_others_);
  main_.show_all(); //Show the main menu and all its child widgets.
  set_main_menu(main_);
  
  // Attach the callback functions to the activate signal.
  item_radio1_.signal_toggled().connect(sigc::mem_fun(*this, &ExampleWindow::on_menu_radio1));
  item_radio2_.signal_toggled().connect(sigc::mem_fun(*this, &ExampleWindow::on_menu_radio2));
  item_check_.signal_toggled().connect(sigc::mem_fun(*this, &ExampleWindow::on_menu_check));
  item_close_.signal_activate().connect(sigc::mem_fun(*this, &ExampleWindow::on_menu_close));
  
  // Make all child widgets visible:
  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_menu_radio1()
{
  std::cout << "Menu radioitem1 toggled. Current state=" << item_radio1_.get_active() << std::endl;
}

void ExampleWindow::on_menu_radio2()
{
  std::cout << "Menu radioitem2 toggled. Current state=" << item_radio2_.get_active() << std::endl;
}

void ExampleWindow::on_menu_check()
{
  std::cout << "Menu chickitem toggled. Current state=" << item_check_.get_active() << std::endl;
}

void ExampleWindow::on_menu_close()
{
  hide();
}

