/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow() :
  table_(2, 2),
  button_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click me!",
    "to print text in entry"),
  label_("Hildon::Entry example"),
  entry_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT)
{
  set_title("Hildon::Entry example");

  table_.attach(button_, 0, 2, 0, 1, Gtk::SHRINK, Gtk::SHRINK);
  table_.attach(label_, 0, 1, 1, 2);
  table_.attach(entry_, 1, 2, 1, 2);

  entry_.set_placeholder("This is placeholder text");

  add(table_);

  button_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  entry_.signal_activate().connect(sigc::mem_fun(*this, &ExampleWindow::on_entry_activated));

  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_clicked()
{
  std::cout << "Button clicked. Current entry text=\"" << entry_.get_text() << "\"." << std::endl;
}

void ExampleWindow::on_entry_activated()
{
  std::cout << "Entry activated. Current text=\"" << entry_.get_text() << "\"." << std::endl;
}

