/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef _MAEMOMM_EXAMPLEWINDOW_H
#define _MAEMOMM_EXAMPLEWINDOW_H

#include <hildonmm/window.h>
#include <hildonmm/app-menu.h>
#include <gtkmm/button.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/togglebutton.h>
#include <gtkmm/label.h>

class ExampleWindow : public Hildon::Window
{
  public:
    ExampleWindow();
    virtual ~ExampleWindow();

  private:
    // Signal handlers:
    void on_button1_clicked();
    void on_button2_clicked();
    void on_radio_toggled();
    void on_toggle1_toggled();
    void on_toggle2_toggled();

    // Child widgets:
    Hildon::AppMenu menu_;
    Gtk::Button button1_;
    Gtk::Button button2_;
    Gtk::RadioButton radio1_;
    Gtk::RadioButton radio2_;
    Gtk::ToggleButton toggle1_;
    Gtk::ToggleButton toggle2_;
    Gtk::Label label_;
};

#endif /* _MAEMOMM_EXAMPLEWINDOW_H */
