/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    wifinetwork.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef WIFINETWORK_H
#define WIFINETWORK_H

#include <QObject>
#include "conditioninterface.h"
#include <QSystemNetworkInfo>
#include <QTimer>

QTM_USE_NAMESPACE

class  WiFiNetwork :  public Condition
{
	Q_OBJECT
	Q_PROPERTY(QString wifiName READ getWifiName WRITE setWifiName NOTIFY notifyWifiName)
	public:
	explicit  WiFiNetwork(ConditionInterface *interface);

	QString getWifiName() const {return wifiName; }
	void setWifiName(QString n) { wifiName = n; emit notifyWifiName(); update();}


	void load(const QByteArray &data);
	QByteArray save() const;

	private slots:
	void update();
	void ChangeInWifiName(QSystemNetworkInfo::NetworkMode,  QString );
	void ChangeInNetwork(QSystemNetworkInfo::NetworkMode mode);
	signals:
	void notifyWifiName();

	private:
	QSystemNetworkInfo * p_networkcl;
	QString wifiName;
	QTimer *tim ;
};

//====================================================
class WiFiNetworkInterface : public ConditionInterface
{
	Q_OBJECT
	Q_INTERFACES(ConditionInterface)

public:
	virtual QString name() const { return tr("Wifi name"); }
	virtual QString vendor() const { return tr("Profiler Team"); }
	virtual QString version() const { return "0.1"; }

	virtual WiFiNetwork *createCondition() { return new WiFiNetwork(this); }

	virtual QUrl qmlGUIFile() const { return QUrl("qrc:WiFiNetwork.qml"); }
	virtual QUrl icon() const  { return QUrl("qrc:WiFiNetwork.png"); }
};
//====================================================

#endif // WIFINETWORK_H
