/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    wifinetwork.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include "wifinetwork.h"
#include <QDebug>

WiFiNetwork::WiFiNetwork(ConditionInterface *interface) :
	Condition(interface)
{
	p_networkcl = new QSystemNetworkInfo(this);
	//connect(p_networkcl,SIGNAL(networkNameChanged(QSystemNetworkInfo::NetworkMode,QString)),this,SLOT(ChangeInWifiName(QSystemNetworkInfo::NetworkMode,  QString )));
	// connect(p_networkcl,SIGNAL(networkModeChanged(QSystemNetworkInfo::NetworkMode)),this ,SLOT(ChangeInNetwork(QSystemNetworkInfo::NetworkMode)));
	update();
	tim = new QTimer(this);
	connect(tim,SIGNAL(timeout()),this,SLOT(update()));
	tim->start(5000);
}

void WiFiNetwork::update()
{
	qDebug() << "je update";

	if(p_networkcl->networkName(QSystemNetworkInfo::WlanMode) == wifiName)
	{
		setState(true);
	}
	else
	{
		setState(false);
	}
}

void WiFiNetwork::ChangeInNetwork(QSystemNetworkInfo::NetworkMode mode)
{
	update();
}

void WiFiNetwork::ChangeInWifiName(QSystemNetworkInfo::NetworkMode mode, QString name)
{
	qDebug() << "jo ted ";
	if(mode == QSystemNetworkInfo::WlanMode)
	{
		qDebug() << "mod ok";
		if(name == wifiName)
		{
			setState(true);
		}
		else
		{
			setState(false);
		}
	}
}
void WiFiNetwork::load(const QByteArray &data)
{
	QDataStream stream(data);

	stream >> wifiName ;
	update();
}

QByteArray WiFiNetwork::save() const
{
	QByteArray data;
	QDataStream stream(&data, QIODevice::WriteOnly);

	stream << wifiName;

	return data;
}

Q_EXPORT_PLUGIN2(wifinetwork, WiFiNetworkInterface)


