/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    betweentime.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include "betweentime.h"

BetweenTime::BetweenTime(ConditionInterface *interface) :
	Condition(interface),starttime(QTime::currentTime()),endtime(QTime::currentTime()),isSetStart(false),isSetEnd(false)
{
	if (++instances == 1)//kdyz bude prvni
	{
		if (!timer)//a neni
			timer = new MinuteTimer(qApp);//tak novej
		timer->start();//tak start
	}
	connect(timer, SIGNAL(timeChanged()), this, SLOT(detectBetween()));
	connect(this, SIGNAL(notifyTimeChangedStart()), this, SLOT(detectBetween()));//kdyz se zmeni cas
	connect(this, SIGNAL(notifyTimeChangedEnd()), this, SLOT(detectBetween()));
}

BetweenTime::~BetweenTime()//kdyz se smaze
{
	if (--instances == 0)
	{
		timer->stop();
	}
}

void BetweenTime::detectBetween()//kdyz je to mezi
{
	qDebug() << "start" << starttime << " end " << endtime ;
	if(!(isSetStart && isSetEnd))
	{
		qDebug() << "jeste neni nastaven" << " min: " << starttime << " max: " << endtime ;
		return;
	}

	//    if( (timer->hour() >= starttime.hour() && timer->minute() >= starttime.minute()) && (timer->hour() <= endtime.hour() && timer->minute()< endtime.minute()))
	//    {
	//je to mezi tema hodiname
	QTime timeFromTimer(timer->hour(),timer->minute());
	qDebug() << "timer " << timeFromTimer ;
	if((timeFromTimer >= starttime) && (timeFromTimer < endtime))
	{
		setState(true);
		emit notifyBoolValueChange();
	}//kdyz se start a end hodiny rovnaj
	else
	{
		setState(false);
		emit notifyBoolValueChange();
	}
	qDebug() << "konec" ;
}

//init pro zacatek
int BetweenTime::instances=0;
MinuteTimer *BetweenTime::timer=0;

void BetweenTime::load(const QByteArray &data)
{
	QDataStream stream(data);

	stream >> endTimeMinute >> endTimeHour >> startTimeMinute  >> startTimeHour >> isSetEnd >> isSetStart >> starttime >> endtime;
}

QByteArray BetweenTime::save() const
{
	QByteArray data;
	QDataStream stream(&data, QIODevice::WriteOnly);

	stream << endTimeMinute << endTimeHour << startTimeMinute  << startTimeHour << isSetEnd << isSetStart << starttime << endtime;

	return data;
}

Q_EXPORT_PLUGIN2(betweentime, BetweenTimeInterface)

