/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
//import QtQuick 1.0
//import Qt.labs.components.native 1.0
//import com.nokia.extras 1.0
import QtQuick 1.0
import org.maemo.fremantle 1.0
import org.maemo.extras 1.0
Rectangle {
    id: rectangle1
    width: 800
    height: 480
    color: "#000000"

    ButtonColumn {
	id: buttoncolumn1
	x: 80
	y: 80
	width: parent.width - (parent.width * 0.2)
	height: parent.height -(parent.width * 0.2)
	anchors.top: parent.top
	anchors.topMargin: 80
	anchors.right: parent.right
	anchors.rightMargin: 80

	Button {
	    id: buttonDark
	    text: "Dark"
	    width: parent.width
	    height: parent.height / 5
	    onClicked: {
		setLevelOfLight(1)
	    }
	}

	Button {
	    id: buttonTwilight
	    text: "Twilight"
	    width: parent.width
	    height: parent.height / 5
	    onClicked: {
		setLevelOfLight(2)
	    }
	}

	Button {
	    id: buttonLight
	    width: parent.width
	    height: parent.height / 5
	    text: "Light"
	    onClicked: {
		setLevelOfLight(3)
	    }
	}

	Button {
	    id: buttonBright
	    width: parent.width
	    height: parent.height / 5
	    text: "Bright"
	    onClicked: {
		setLevelOfLight(4)
	    }
	}
	Button {
	    id: buttonSunny
	    width: parent.width
	    height: parent.height / 5
	    text: "Sunny"
	    onClicked: {
		setLevelOfLight(5)
	    }
	}
    }

    function setLevelOfLight(value)
    {
	Instance.lightLevel = value;
    }

    Text {
	id: text1
	x: 80
	y: 35
	width: 66
	height: 36
 color: "#ffffff"
	text: qsTr("Light level is ")
	font.pixelSize: 36

	Text {
	    id: textLevel
	    x: 209
	    y: 0
	    width: 377
	    height: 41
     color: "#ffffff"
	    text: " "
	    font.pixelSize: 36
	}
    }

    Connections {
	target: Instance
	onNotifyLightLevelMobileValueChange: changeText(Instance.getLightMobileLevel())
	ignoreUnknownSignals: true
    }

    Component.onCompleted: {
	changeText(Instance.getLightMobileLevel());
	checkButton(Instance.lightLevel);
    }

    function checkButton(param)
    {
	switch(param) {
	case 1 : buttoncolumn1.checkedButton = buttonDark; break;
	case 2 : buttoncolumn1.checkedButton = buttonTwilight; break;
	case 3 : buttoncolumn1.checkedButton = buttonLight; break;
	case 4 : buttoncolumn1.checkedButton = buttonBright; break;
	case 5 : buttoncolumn1.checkedButton= buttonSunny; break;
	//default : textLevel.text = "Error"; break;
	}
    }


    function changeText(param)
    {
	switch(param) {
	case 1 : textLevel.text = "dark"; break;
	case 2 : textLevel.text = "twilight"; break;
	case 3 : textLevel.text = "light"; break;
	case 4 : textLevel.text = "bright"; break;
	case 5 : textLevel.text = "sunny"; break;

	default : textLevel.text = "Error"; break;
	}
    }

    //    Text {
    //        text: qsTr("Hello World")
    //        anchors.centerIn: parent
    //    }
    //    MouseArea {
    //        anchors.fill: parent
    //        onClicked: {
    //            Qt.quit();
    //        }
    //    }




}
