/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    main.qml
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

//import QtQuick 1.0
//import Qt.labs.components.native 1.0
//import com.nokia.extras 1.0
import QtQuick 1.0
import org.maemo.fremantle 1.0
import org.maemo.extras 1.0

Rectangle {
    id: rectangle1
    width: 800
    height: 480
    color: "#000000"


    ButtonColumn {
        id: buttoncolumn1
        x: 80
        y: 93
        width: parent.width - (parent.width * 0.2)
        height: parent.height -(parent.width * 0.2)
        anchors.top: parent.top
        anchors.topMargin: 93
        anchors.right: parent.right
        anchors.rightMargin: 80
        //checkedButton : Instance.selectedBlueToothState == true ? buttonBlueToothOn : buttonBlueToothOff

        Button {
            id: buttonBlueToothOff
            text: "BlueTooth off"
            width: parent.width
            height: parent.height / 2
            onClicked: {
                setSelectedState(false)
            }
        }

        Button {
            id: buttonBlueToothOn
            text: "BlueTooth on"
            width: parent.width
            height: parent.height / 2
            onClicked: {
                setSelectedState(true)
            }
        }
    }




    Text {
        id: text1
        x: 86
        y: 38
        width: 66
        height: 36
        color: "#ffffff"
        text: qsTr("BlueTooth is ")
        font.pixelSize: 36

        Text {
            id: textLevel
            x: 204
            y: 0
            width: 382
            height: 41
            color: "#ffffff"
            text:" "
            font.pixelSize: 36
        }
    }

    Connections {
        target: Instance
        onNotifyBlueToothStateChanged: changeText(Instance.getBlueToothState())
    }

    Component.onCompleted: {
        changeText(Instance.getBlueToothState());
        checkButton(Instance.selectedBlueToothState);
    }

    function checkButton(param)
    {
        if(param)
        {
            buttoncolumn1.checkedButton = buttonBlueToothOn;
        }
        else
        {
            buttoncolumn1.checkedButton = buttonBlueToothOff;
        }
    }

    function changeText(param)
    {
        if(param)
        {
            textLevel.text = "on";
        }
        else
        {
            textLevel.text = "off";
        }
    }

    function setSelectedState(value)
    {
        Instance.selectedBlueToothState = value;
    }


}
