/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    bluetoothstate.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef BLUETOOTHSTATE_H
#define BLUETOOTHSTATE_H
#include "conditioninterface.h"
#include <QSystemDeviceInfo>

QTM_USE_NAMESPACE

class BlueToothState : public Condition
{
	Q_OBJECT
	Q_PROPERTY(bool selectedBlueToothState READ getSelectedBlueToothState WRITE setSelectedBlueToothState NOTIFY notifySelectedBlueToothState)
public:
	explicit BlueToothState(ConditionInterface *interface);


	inline bool getSelectedBlueToothState() const { return selectedBlueToothState;}
	inline void setSelectedBlueToothState(bool i) { selectedBlueToothState = i; emit notifySelectedBlueToothState(); update();}

	Q_INVOKABLE bool getBlueToothState() { return deviceInfo->currentBluetoothPowerState(); }



	void update();

	virtual void load(const QByteArray &data);
	virtual QByteArray save() const;

signals:

	void notifySelectedBlueToothState();
	void notifyBlueToothStateChanged();
public slots:
	void  blueToothStateChanged(bool);
private:

	bool selectedBlueToothState;


	QSystemDeviceInfo * deviceInfo;

};
//====================================================
class BlueToothStateInterface : public ConditionInterface
{
	Q_OBJECT
	Q_INTERFACES(ConditionInterface)

public:
	virtual QString name() const { return tr("BlueTooth Status"); }
	virtual QString vendor() const { return tr("Profiler Team"); }
	virtual QString version() const { return "0.1"; }

	virtual BlueToothState *createCondition() { return new BlueToothState(this); }

	virtual QUrl qmlGUIFile() const { return QUrl("qrc:BlueToothState.qml"); }
	virtual QUrl icon() const { return QUrl("qrc:bluetooth.png"); }
};
//====================================================

#endif // BLUETOOTHSTATE_H
