/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    screenon.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef SCREENON_H
#define SCREENON_H

#include <QObject>
#include <QTimer>
#include <QSystemDeviceInfo>
#include "actioninterface.h"
QTM_USE_NAMESPACE

class QDBusInterface;
class ScreenON : public Action
{
	Q_OBJECT
public:
	explicit ScreenON(ActionInterface *interface);

	virtual void doAction();
	void stopAction();
	virtual void load(const QByteArray &data);
	virtual QByteArray save() const;
signals:

public slots:

private slots:
	void timerTimeout();

private:
	QDBusInterface *connectionInterfaceForDisplay ;
	QTimer * timerForScreen;
	QSystemDeviceInfo dev;
};
//====================================================
class ScreenOnInterface : public ActionInterface
{
	Q_OBJECT
	Q_INTERFACES(ActionInterface)

public:
	virtual QString name() const { return tr("Screen"); }
	virtual QString vendor() const { return tr("Profiler Team"); }
	virtual QString version() const { return "0.1"; }

	virtual ScreenON *createAction() { return new ScreenON(this); }

	virtual QUrl qmlGUIFile() const { return QUrl("qrc:ScreenON.qml"); }
	virtual QUrl icon() const { return QUrl("qrc:screenon.png"); }
};
//====================================================

#endif // SCREENON_H
