/*
Copyright (c) 2012, Petr Pehal, Jakub  plíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    main.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include <QtGui/QApplication>
#include <QtDeclarative>
#include "../qmlapplicationviewer/qmlapplicationviewer.h"
#include "gui/customitem.h"
#include <QtDeclarative>
//#include <QtDBus/QtDBus>
#include "core/profilercontroller.h"
#include "core/utils.h"

/*************************************************************************************************/

#define EXIT_CODE1	1
#define EXIT_CODE2	2
#define EXIT_CODE3	3

/*************************************************************************************************/
// MAIN
/*************************************************************************************************/

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);

	ProfilerController profiler;

	QmlApplicationViewer viewer;


//    if (!QDBusConnection::sessionBus().isConnected()) {
//        qWarning("Cannot connect to the D-Bus session bus.");
//        return EXIT_CODE1;
//    }

//	if (!QDBusConnection::sessionBus().registerService("org.indt.profilertam")) {
//		qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
//								  message()));
//		return EXIT_CODE2;
//	}

//	if (!QDBusConnection::sessionBus().registerObject("/org/indt/profilertam", &viewer,
//													  QDBusConnection::ExportScriptableSlots)) {
//		qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
//								  message()));
//		return EXIT_CODE3;
//	}



	if (!profiler.loadPlugins()) {
		ERROR("ProfilerController: Cannot load plugins");
	}

	if (!profiler.loadProfiles()) {
		ERROR("ProfilerController: Cannot load profiles");
	}

	profiler.registerQmlViewer(&viewer);


	viewer.setMainQmlFile(QLatin1String("qml/main.qml"));
	viewer.showExpanded();

	return app.exec();
}

/*************************************************************************************************/
