#include "customitem.h"

CustomItem::CustomItem(const QString &name, QObject *parent) : ListItem(parent), m_name(name)
{
}

QHash<int, QByteArray> CustomItem::roleNames() const
{
	QHash<int, QByteArray> names;
	names[NameRole] = "name";
	names[ReadyRole] = "ready";
	return names;
}

QVariant CustomItem::data(int role) const
{
	switch(role) {
	case NameRole:
		return name();
//	case ReadyRole:
	default:
		return QVariant();
	}
}

bool CustomItem::setData(int role, const QVariant &value)
{
	qDebug() << "setData";

	switch(role) {
	case NameRole:
		m_name = value.toString();
		return true;
	default:
		break;
	}

	return false;
}
