/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    configreader.h
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#ifndef UMLITEMSREADER_H
#define UMLITEMSREADER_H

/*************************************************************************************************/

#include <QXmlStreamReader>

/*************************************************************************************************/
// FORWARD DECLARATIONS
/*************************************************************************************************/

class Profile;
class ProfileController;
class ConditionInterface;
class ActionInterface;

/*************************************************************************************************/
// CONFIG READER DATA
/*************************************************************************************************/

struct ConfigReaderData
{
	Profile            *currentProfile;
	ConditionInterface *currentConditionInterface;
	ActionInterface    *currentActionInterface;

	QObjectList        profiles;
};

/*************************************************************************************************/
// CONFIG READER
/*************************************************************************************************/

class ConfigReader : public QXmlStreamReader
{
public:
	explicit ConfigReader(const QString &data);
	~ConfigReader();

	bool read();

	inline QObjectList profiles() const { return d->profiles; }

private:
	void readProfiles();
	void readProfile();
	void readConditions();
	void readActions();
	void readCondition();
	void readAction();

	void raiseIError();
	void raiseError();
	void raiseError(const QString &message);

private:
	ConfigReaderData *d;
};

/*************************************************************************************************/

#endif // UMLITEMSREADER_H
