# -*- coding: utf-8 -*-

"""
Module implementing MainWindow.
"""

from PyQt4.QtCore import pyqtSignature, QEvent, SIGNAL, QRect
from PyQt4.QtGui import QMainWindow, QGraphicsScene, QTransform, QMessageBox, QGraphicsView
from PyQt4.QtSvg import QGraphicsSvgItem 
#import pygame as pg
from pygame import mixer, init as pginit
import time


#This is the Pygame version for Audio

from Ui_sound import Ui_MainWindow

class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        FREQ = 22050   # play with this for best sound
        BITSIZE = -16  # here unsigned 16 bit
        CHANNELS = 2   # 1 is mono, 2 is stereo
        BUFFER = 32 # audio buffer size, number of samples
        

        mixer.pre_init(FREQ, BITSIZE, CHANNELS, BUFFER)
        pginit()

        #mixer.init(FREQ, BITSIZE, CHANNELS, BUFFER)
 

 
        # create a new Sound object from a file
        self.sound1=mixer.Sound("/home/opt/maelophone/stylo_smpl/a2.wav")      #a
        self.sound15=mixer.Sound("/home/opt/maelophone/stylo_smpl/a#2.wav") #a sharp
        self.sound2=mixer.Sound("/home/opt/maelophone/stylo_smpl/b2.wav")      #b
        self.sound3=mixer.Sound("/home/opt/maelophone/stylo_smpl/c3.wav")      #c
        self.sound35=mixer.Sound("/home/opt/maelophone/stylo_smpl/c#3.wav")      #c sharp
        self.sound4=mixer.Sound("/home/opt/maelophone/stylo_smpl/d3.wav")      #d
        self.sound45=mixer.Sound("/home/opt/maelophone/stylo_smpl/d#3.wav")  #d sharp
        self.sound5=mixer.Sound("/home/opt/maelophone/stylo_smpl/e3.wav")       #e
        self.sound6=mixer.Sound("/home/opt/maelophone/stylo_smpl/f3.wav")       #f
        self.sound65=mixer.Sound("/home/opt/maelophone/stylo_smpl/f#3.wav")  #f sharp
        self.sound7=mixer.Sound("/home/opt/maelophone/stylo_smpl/g3.wav")       #g
        self.sound75=mixer.Sound("/home/opt/maelophone/stylo_smpl/g#3.wav")  #g sharp
        self.sound8=mixer.Sound("/home/opt/maelophone/stylo_smpl/a3.wav")      #a
        self.sound85=mixer.Sound("/home/opt/maelophone/stylo_smpl/a#3.wav")  #a sharp
        self.sound9=mixer.Sound("/home/opt/maelophone/stylo_smpl/b3.wav")      #b
        self.sound10=mixer.Sound("/home/opt/maelophone/stylo_smpl/c4.wav")    #c
        self.sound105=mixer.Sound("/home/opt/maelophone/stylo_smpl/c#4.wav") #c sharp
        self.sound11=mixer.Sound("/home/opt/maelophone/stylo_smpl/d4.wav")     #d
        self.sound115=mixer.Sound("/home/opt/maelophone/stylo_smpl/d#4.wav")  #d sharp
        self.sound12=mixer.Sound("/home/opt/maelophone/stylo_smpl/e4.wav")     #e
     
        self.decay=10
        self.vol=0.5
     
        
        #Build the Keyboard using QGraphicsView
        self.buttonid=0
        self.scene = QGraphicsScene()
        self.sceneWidth=0
        self.sceneHeight=0
        self.centerx=0
        self.centery=0
        self.svgRect=QRect()
        #self.svgRect.setX(self.xoffset)
        #self.svgRect.setY(self.yoffset)
        #self.fullScreen=0
        
        #Load the Keyboard picture. The Graphics View is 640X110px, each button os 53px wide with  at the ends2pix border
        self.svgKeys=QGraphicsSvgItem("/home/opt/maelophone/keys.svg")
        renderer=self.svgKeys.renderer()
        self.svgKeys.setZValue(1)
        self.svgKeys.setPos(0, 0)
        self.scene.addItem(self.svgKeys)
        
        self.sceneWidth=self.scene.itemsBoundingRect().width()
        self.sceneHeight=self.scene.itemsBoundingRect().height()
        #print self.sceneWidth, self.sceneHeight
        self.centerx=self.sceneWidth/2
        self.centery=self.sceneHeight/2
        self.grView.centerOn(self.centerx, self.centery)
        #self.scene.setSceneRect(0, 0,self.sceneWidth, self.sceneHeight)
        #self.grView.resetTransform()
        #scaleFactor=480/self.sceneHeight
        self.grView.scale(1, 0.95)
        self.grView.setScene(self.scene)
        
        self.connect(self.grView, SIGNAL("stylo pressed"),self.pushButtonPressed, self.buttonid)
        self.connect(self.grView, SIGNAL("stylo released"),self.pushButtonReleased, self.buttonid)
        self.connect(self.grView, SIGNAL("stylo changed"),self.pushButtonEntered, self.buttonid)
        
    
    def pushButtonPressed(self, buttonid):
        #play a 5 second burst (-1,5000) minus species play contiunous
   
        if buttonid == 1: channel=self.sound1.play(-1)
        elif buttonid == 15: channel=self.sound15.play(-1)
        elif buttonid == 2: channel=self.sound2.play(-1)
        elif buttonid == 3: channel=self.sound3.play(-1)
        elif buttonid == 35: channel=self.sound35.play(-1)
        elif buttonid == 4: channel=self.sound4.play(-1)
        elif buttonid == 45: channel=self.sound45.play(-1)
        elif buttonid == 5: channel=self.sound5.play(-1)
        elif buttonid == 6: channel=self.sound6.play(-1)
        elif buttonid == 65: channel=self.sound65.play(-1)
        elif buttonid == 7: channel=self.sound7.play(-1)
        elif buttonid == 75: channel=self.sound75.play(-1)
        elif buttonid == 85: channel=self.sound85.play(-1)
        elif buttonid == 8: channel=self.sound8.play(-1)
        elif buttonid == 9: channel=self.sound9.play(-1)
        elif buttonid == 10: channel=self.sound10.play(-1)
        elif buttonid == 105: channel=self.sound105.play(-1)
        elif buttonid == 11: channel=self.sound11.play(-1)
        elif buttonid == 115: channel=self.sound115.play(-1)
        elif buttonid == 12: channel=self.sound12.play(-1)
        #print "channel id", channel
   
    def pushButtonReleased(self, buttonid):
        #mixer.stop()
        #print"mixer stopping"
        #mixer.stop()
        mixer.fadeout(self.decay)
        
    @pyqtSignature("")
    def on_closeButton_pressed(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        self.close()
        
    @pyqtSignature("int")
    def on_decaySlider_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        self.decay=value
            
        
        
    @pyqtSignature("int")
    def on_volSlider_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
      
        if value>=1:self.vol=value/10.0
       # print"Vol" , value , self.vol
        
        self.sound1.set_volume(self.vol)
        self.sound15.set_volume(self.vol)
        self.sound2.set_volume(self.vol)
        self.sound3.set_volume(self.vol)
        self.sound35.set_volume(self.vol)
        self.sound4.set_volume(self.vol)
        self.sound45.set_volume(self.vol)
        self.sound5.set_volume(self.vol)
        self.sound6.set_volume(self.vol)
        self.sound65.set_volume(self.vol)
        self.sound7.set_volume(self.vol)
        self.sound75.set_volume(self.vol)
        self.sound8.set_volume(self.vol)
        self.sound85.set_volume(self.vol)
        self.sound9.set_volume(self.vol)
        self.sound10.set_volume(self.vol)
        self.sound105.set_volume(self.vol)
        self.sound11.set_volume(self.vol)
        self.sound115.set_volume(self.vol)
        self.sound12.set_volume(self.vol)
        
        channel=self.sound6.play()
   
    def pushButtonEntered(self, buttonid):
        mixer.fadeout(self.decay)
        if buttonid == 1: channel=self.sound1.play(-1)
        elif buttonid == 15: channel=self.sound15.play(-1)
        elif buttonid == 2: channel=self.sound2.play(-1)
        elif buttonid == 3: channel=self.sound3.play(-1)
        elif buttonid == 35: channel=self.sound35.play(-1)
        elif buttonid == 4: channel=self.sound4.play(-1)
        elif buttonid == 45: channel=self.sound45.play(-1)
        elif buttonid == 5: channel=self.sound5.play(-1)
        elif buttonid == 6: channel=self.sound6.play(-1)
        elif buttonid == 65: channel=self.sound65.play(-1)
        elif buttonid == 7: channel=self.sound7.play(-1)
        elif buttonid == 75: channel=self.sound75.play(-1)
        elif buttonid == 85: channel=self.sound85.play(-1)
        elif buttonid == 8: channel=self.sound8.play(-1)
        elif buttonid == 9: channel=self.sound9.play(-1)
        elif buttonid == 10: channel=self.sound10.play(-1)
        elif buttonid == 105: channel=self.sound105.play(-1)
        elif buttonid == 11: channel=self.sound11.play(-1)
        elif buttonid == 115: channel=self.sound115.play(-1)
        elif buttonid == 12: channel=self.sound12.play(-1)
        #print "channel id", channel
