#ifndef DIALOGCALENDARLIST_H
#define DIALOGCALENDARLIST_H

#include <QDialog>

class QMaemo5AbstractPickSelector;
class QModelIndex;

namespace Ui {
class DialogCalendarList;
}

class DialogCalendarList : public QDialog
{
    Q_OBJECT
    
public:
    explicit DialogCalendarList(QWidget *parent = 0);
    ~DialogCalendarList();

    QString getCalendarName();
    QString getCalendarType();
    int getCalendarId();
    void setPicker(QMaemo5AbstractPickSelector* picker);

signals:
    QString selected (const QString & valueText);
    void calendarIdChanged(const int calendarId);
    void calendarTextChanged(const QString &calendarText);

private slots:


    void on_listView_activated(const QModelIndex &index);



private:
    Ui::DialogCalendarList *ui;

    int calendarId;
    QString calendarType;
    QString calendarName;
    QMaemo5AbstractPickSelector* picker;
};

#endif // DIALOGCALENDARLIST_H
