#ifndef FORMTASKLISTNAVIGATOR_H
#define FORMTASKLISTNAVIGATOR_H

#include <QWidget>
class QMenuBar;

namespace Ui {
class FormTaskListNavigator;
}

class FormTaskListNavigator : public QWidget
{
    Q_OBJECT
    
public:
    explicit FormTaskListNavigator(QWidget *parent = 0);
    ~FormTaskListNavigator();
    
    void setSQLWhereClause(QString WhereClause);
    //void setSQLOrderClause(QString OrderClause);
    void updateQuery();
    void hideTaskButton(bool hide);
    void hideNoteButton(bool hide);
    void hideFolderButton(bool hide);

    void setFolderId(int FolderId);

signals:
    void folderAddedOrRemoved();
    void folderAdded(int FolderId);
    void folderRemoved(int FolderId);

private slots:
    void on_buttonTask_clicked();

    void on_buttonFolder_clicked();

    void on_buttonNote_clicked();

    void triggered(QAction* action);

private:
    Ui::FormTaskListNavigator *ui;
    int folderId;
    QMenuBar* menuBar;
    QAction* deleteFolderAction;
};

#endif // FORMTASKLISTNAVIGATOR_H
