#include "mylistview.h"

MyListView::MyListView(QWidget *parent) :
    QListView(parent)
{
}

void MyListView::mouseReleaseEvent(QMouseEvent *e){
    //cout << "MyListWidget::mouseReleaseEvent()!" << endl;
    MyListView::clearSelection();     //we don't want items to stay selected in our UI.
    QListView::mouseReleaseEvent(e);  //call parent mouserelease so signals fire for QListWidget
}

void MyListView::stretchHeight(){
    int height = 0;
    //height = MyListView::sizeHintForRow(0) * MyListView::count();
    height = MyListView::sizeHintForRow(0) * this->model()->rowCount();
    MyListView::setMinimumHeight(height);
}

void MyListView::paintEvent(QPaintEvent *e){
    stretchHeight();
    QListView::paintEvent(e);
}
