#include "mainwindow.h"
#include "eventswindow.h"
#include "ui_mainwindow.h"
#include "QSqlQueryModel"
#include "database.h"
#include <iostream>
#include "QtGui"

using namespace std;

EventsWindow *ew;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);


    QSqlQueryModel *model = new QSqlQueryModel;
    model->setQuery(SQL_GET_CAL_WITH_RECURRING);


    ui->listView->setModel(model);
    ui->listView->setModelColumn(1);

}

MainWindow::~MainWindow()
{
    delete ui;
}


void MainWindow::on_listView_activated(QModelIndex index)
{
    cout << "TESTING" << endl;
    cout << "INDEX DATA" << index.data().toString().toLocal8Bit().constData() << endl;
    cout << "SIBLING" << index.sibling(index.row(), 0).data().toString().toLocal8Bit().constData() <<endl;
    //cout << index.data().toInt();

    //cout << "showing window" << endl;
    if(!ew){
        cout << "creating new pointer for EventsWindow" << endl;
        ew = new EventsWindow(this);
    }


    cout << "setting stacked window attribute";

    //prepare the window's view
    ew->setCalendarId(index.sibling(index.row(),0).data().toInt());
    ew->setCalendarName(index.data().toString());
    ew->setCalendarIdQuery();

    ew->setAttribute(Qt::WA_Maemo5StackedWindow);
    ew->setWindowFlags(ew->windowFlags() | Qt::Window);
    ew->show();



    //QPushButton button2("Click here to open another stacked window", this);
    //button2.setAttribute(Qt::WA_Maemo5StackedWindow);
    //button2.setWindowFlags(button2.windowFlags() | Qt::Window);


    //QLabel label("<p align=\"center\">This is the last stacked window. "
    //             "Press the back arrow on the top-right corner to go back.",
    //             &button2, Qt::Window);
    //label.setAttribute(Qt::WA_Maemo5StackedWindow);
    //label.setWordWrap(true);

    //QObject::connect(&button1, SIGNAL(clicked()), &button2, SLOT(show()));
    //QObject::connect(&button2, SIGNAL(clicked()), &label, SLOT(show()));

    //button2.show();

}
