#ifndef EVENTVIEW_H
#define EVENTVIEW_H

#include <QScrollArea>
#include <calendar-backend/CEvent.h>
#include <calendar-backend/CRecurrenceRule.h>

namespace Ui {
    class EventView;
}

class EventView : public QScrollArea
{
    Q_OBJECT

public:
    explicit EventView(QWidget *parent = 0);
    ~EventView();
    void setCalendarId(int calendarid);
    void setEventId(int eventid);
    void loadEventInfo();
    QString resolveRType(int rType);

private:
    Ui::EventView *ui;
    CEvent *m_event;
    CRecurrenceRule *m_firstrule;

    int m_calendarid;
    int m_eventid;
    bool getEvent(int calendarid, int eventid);
    void debugRecurrence();
    void testRecurrence();
    bool saveRule(QString rule, int until, int rType);

private slots:
    void on_pushButton_clicked();

};

#endif // EVENTVIEW_H
