#include "eventswindow.h"
#include "ui_eventswindow.h"
#include <iostream>
#include <QSqlQueryModel>
#include "database.h"
#include "eventview.h"


using namespace std;

EventView *ev;

EventsWindow::EventsWindow(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::EventsWindow),model(new QSqlQueryModel)
{
    ui->setupUi(this);

    //QSqlQueryModel *model = new QSqlQueryModel;
    model->setQuery("select id, summary from components where 1=2");

    ui->listView->setModel(model);
    ui->listView->setModelColumn(1);

    m_calendarid = 0;
}

EventsWindow::~EventsWindow()
{
    delete ui;
    delete ev;
}

void EventsWindow::setCalendarId(const int calendarId){
    m_calendarid = calendarId;


}

const int EventsWindow::getCalendarId() const {
    return m_calendarid;
}

void EventsWindow::setCalendarName(QString name){
    this->m_calendarname = name;
    ui->label->setText("Recurring Events for Calendar: " + name);
}

void EventsWindow::setQuery(QString sql){
    model->setQuery(sql);
}

void EventsWindow::setCalendarIdQuery(){
    QString q = QString("select a.id, a.summary from components a join recursive b on a.id=b.id where a.CalendarId=");
    //QString q = QString("select a.id, a.summary from components a where a.CalendarId=");
    q.append(QVariant(m_calendarid).toString());
    cout << "query:" << q.toLocal8Bit().constData() << endl;
    model->setQuery(q);
}

void EventsWindow::on_listView_activated(QModelIndex index)
{
    cout << "TESTING" << endl;
    cout << "INDEX DATA" << index.data().toString().toLocal8Bit().constData() << endl;
    cout << "SIBLING" << index.sibling(index.row(), 0).data().toString().toLocal8Bit().constData() <<endl;
    //cout << index.data().toInt();

    //cout << "showing window" << endl;
    if(!ev){
        cout << "creating new pointer for EventsWindow" << endl;
        ev = new EventView(this);
    }


    cout << "setting stacked window attribute" << endl;

    //prepare the window's view
    //ew->setCalendarId(index.sibling(index.row(),0).data().toInt());
    //ew->setCalendarIdQuery();
    ev->setCalendarId(m_calendarid);
    ev->setEventId(index.sibling(index.row(),0).data().toInt());
    ev->loadEventInfo();

    ev->setAttribute(Qt::WA_Maemo5StackedWindow);
    ev->setWindowFlags(ev->windowFlags() | Qt::Window);
    ev->show();
    cout << "end of activated() method" << endl;
}
