#include "dialogruleweekly.h"
#include "ui_dialogruleweekly.h"

DialogRuleWeekly::DialogRuleWeekly(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogRuleWeekly)
{
    ui->setupUi(this);
}

DialogRuleWeekly::~DialogRuleWeekly()
{
    delete ui;
}

QString DialogRuleWeekly::getRule(){
    QString rule("FREQ=WEEKLY");
    this->rType = 3;
    if(ui->spinBox->value() > 1){
        rule.append(";INTERVAL=");
        rule.append(QString::number(ui->spinBox->value()));
    }
    bool byday = ui->checkBoxSU->isChecked() ||
                 ui->checkBoxMO->isChecked() ||
                 ui->checkBoxTU->isChecked() ||
                 ui->checkBoxWE->isChecked() ||
                 ui->checkBoxTH->isChecked() ||
                 ui->checkBoxFR->isChecked() ||
                 ui->checkBoxSA->isChecked();

    if(byday){
        rule += ";BYDAY=";
        QString tmp;
        if(ui->checkBoxSU->isChecked())
            tmp += ",SU";
        if(ui->checkBoxMO->isChecked())
            tmp += ",MO";
        if(ui->checkBoxTU->isChecked())
            tmp += ",TU";
        if(ui->checkBoxWE->isChecked())
            tmp += ",WE";
        if(ui->checkBoxTH->isChecked())
            tmp += ",TH";
        if(ui->checkBoxFR->isChecked())
            tmp += ",FR";
        if(ui->checkBoxSA->isChecked())
            tmp += ",SA";

        tmp.remove(0,1); //remove leading comma
        rule += tmp;

        this->rType = 6; //complex rule
    }

    return rule;
}

int DialogRuleWeekly::getRType(){
    return this->rType;
}
