#include "dialogeditrule.h"
#include "ui_dialogeditrule.h"
#include "dialogeditrange.h"
#include "dialogeditrepeat.h"
#include <iostream>

using namespace std;

DialogEditRule::DialogEditRule(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogEditRule)
{
    ui->setupUi(this);

    this->dirty = false;
    this->patternUpdated = false;
    this->rangeUpdated = false;
    this->until = -1;

}

DialogEditRule::~DialogEditRule()
{
    delete ui;
}

void DialogEditRule::on_rangeButton_clicked()
{
    DialogEditRange winEditRange(this);
    winEditRange.setWindowState(winEditRange.windowState() ^ Qt::WindowMaximized);
    winEditRange.exec();

    if(winEditRange.result()){
        cout << "saving range update" << endl;
        this->rangeType = winEditRange.getRangeType();

        this->until = winEditRange.getUntilForComponent();
        cout << "UNTIL time_t is:" << this->until << endl;
        this->ruleRange = winEditRange.getRange();
        this->rangeUpdated = true;
        updateRule();

    }

}

void DialogEditRule::on_patternButton_clicked()
{
    DialogEditRepeat winEditRepeat(this);
    winEditRepeat.setWindowState(winEditRepeat.windowState() ^ Qt::WindowMaximized);
    winEditRepeat.exec();
    cout << "RESULT:" << winEditRepeat.result() << endl;

    if(winEditRepeat.result()){
        this->ruleRepeat = winEditRepeat.getRepeat();
        this->rType = winEditRepeat.getRtype();

        this->patternUpdated = true;

        if(this->rType == -1){
            ui->rangeButton->setEnabled(false);
            this->ruleRange = "";
            this->rangeType = -1;
        } else {
            ui->rangeButton->setEnabled(true);
        }

        updateRule();

    }
}

void DialogEditRule::updateRule(){
    QString rule(this->ruleRepeat);
    this->dirty = true;
    if(this->rangeUpdated &&  this->rangeType > 1){
        rule += ";" + this->ruleRange;
    }
    ui->lineEdit->setText(rule);
}

QString DialogEditRule::getRule(){
    return ui->lineEdit->text();
}

void DialogEditRule::setRule(QString rule){
    ui->lineEdit->setText(rule);
}

int DialogEditRule::getRType(){
    return this->rType;
}

int DialogEditRule::getUntil(){
    return this->until;
}
