#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pygtk
pygtk.require('2.0')
import gtk
import pynotify
import sys
import dbus
import dbus.glib
import dbus.service
import osso
import hildon
import gobject

from datetime import *

# Define some constants
MCE_SIGNAL_NAME = 'sig_device_orientation_ind'
MCE_SIGNAL_IFACE = 'com.nokia.mce.signal'
MCE_SIGNAL_PATH = '/com/nokia/mce/signal'


MCE_SERVICE = 'com.nokia.mce'
MCE_REQUEST_PATH =  '/com/nokia/mce/request'
MCE_REQUEST_IF = 'com.nokia.mce.request'
MCE_DEVICE_ORIENTATION_GET = 'get_device_orientation'
MCE_DEVICE_DISPSTATUS_GET = 'get_display_status'
MCE_DEVICE_SCRLOCK_GET = 'get_tklock_mode'

ENABLE_LED = 'req_led_pattern_activate'
DISABLE_LED = 'req_led_pattern_deactivate'
VIBRATE  = 'req_vibrator_pattern_activate'
VIBRATE_PATTERN = 'PatternChatAndEmail'
LED_PATTERN ='PatternCommunicationSMS'# 'PatternCommunicationIM'

SH_DBUS_NAME  ="cn.l32606.maebo"
SH_DBUS_IFACE ="cn.l32606.maebo"
SH_DBUS_PATH  ="/cn/l32606/maebo"
SH_SHARE_SIG  ="send_via_service"

SESSION_DBUS_NAME  ="cn.l32606.maebo_session"
SESSION_DBUS_IFACE ="cn.l32606.maebo_session"
SESSION_DBUS_PATH  ="/cn/l32606/maebo_session"
SESSION_SHARE_SIG  ="show_window"

NOTIFY_DBUS_NAME  ="cn.l32606.qt_pynotify"
NOTIFY_DBUS_IFACE ="cn.l32606.qt_pynotify"
NOTIFY_DBUS_PATH  ="/cn/l32606/qt_pynotify"
NOTIFY_SHARE_SIG_SHOW  ="show_notify"
NOTIFY_SHARE_SIG_UPDATE  ="update_notify"
NOTIFY_SHARE_SIG_QUIT  ="quit_app"

class qt_pynotify():
    """ GUI class for the application. """

    def __init__(self):
        """ Initializes the GUI, creating all widgets. """

        print "Run..."
        self.osso_c = osso.Context(NOTIFY_DBUS_NAME, "0.0.1", False)
        self.osso_rpc = osso.Rpc(self.osso_c)
        self.osso_rpc.set_rpc_callback(NOTIFY_DBUS_NAME, NOTIFY_DBUS_PATH, NOTIFY_DBUS_IFACE, self.cb_notify_process, self.osso_c)
        self.notis={}
        self.noti_num = 0
        
    def close_cb(self, n, action=None):
        print "close_cb", n.get_data("account_idx"), n.get_data("optype")
        
        self.notis[n.get_data("account_idx")+":t"+n.get_data("optype")] = None
        self.osso_rpc.rpc_run(SH_DBUS_NAME, SH_DBUS_PATH, SH_DBUS_IFACE, "clear_unread", 
            rpc_args=(n.get_data("account_idx"),n.get_data("optype")), wait_reply=False, use_system_bus=False)  

    def cb_notify_process(self, interface, method, args, user_data):
        print "cb_notify_process"
        
        if method == NOTIFY_SHARE_SIG_SHOW:
           # args[0] = account_idx, args[1] = optype, args[2] = nickname, args[3] = text, args[4] = iconstr
            print NOTIFY_SHARE_SIG_SHOW, args[0], args[1],args[2], args[3], args[4]
            try:
                if self.notis[args[0]+":t"+args[1]] == None:
                    print "notify create [" +args[0]+":t"+args[1]+"]"
                else:
                    print "notify update [" +args[0]+":t"+args[1]+"]"                    
            except:                
                print "notify new [" +args[0]+":t"+args[1]+"]"
                self.notis[args[0]+":t"+args[1]] = None
                pass
    
        
            if self.notis[args[0]+":t"+args[1]] == None:
                self.notis[args[0]+":t"+args[1]] = pynotify.Notification(args[2], args[3], args[4])
                self.notis[args[0]+":t"+args[1]].set_urgency(pynotify.URGENCY_CRITICAL)

                self.notis[args[0]+":t"+args[1]].connect("closed", self.close_cb)
                self.noti_num = self.noti_num + 1
                self.notis[args[0]+":t"+args[1]].set_data("account_idx", args[0])
                self.notis[args[0]+":t"+args[1]].set_data("optype", args[1])
                self.notis[args[0]+":t"+args[1]].set_hint("dbus-callback-default", \
                    SH_DBUS_NAME + " " + SH_DBUS_PATH + " " + SH_DBUS_IFACE + \
                    " "+ "open_mentions string:\""+args[0]+"\"" + " string:\""+args[1]+"\"")
                
                if not self.notis[args[0]+":t"+args[1]].show():
                    print "Failed to send notification"
                    
            else:
                try:
                    print "notify update [" +args[0]+":t"+args[1]+"]", args[3]
                    nn = self.notis[args[0]+":t"+args[1]]
                    nn.update(args[2], args[3], args[4])
                    nn.close()
                    if not nn.show():
                        print "Failed to update notification"
 
                except:
                    print "update [" + args[0]+":t"+args[1] +"] error."
                    self.notis[args[0]+":t"+args[1]] = None
                    pass
                    
 
        elif method == NOTIFY_SHARE_SIG_UPDATE:    
           # args[0] = account_idx, args[1] = optype, args[2] = nickname, args[3] = text, args[4] = iconstr
            #print NOTIFY_SHARE_SIG_UPDATE, args[0], args[1],args[2], args[3], args[4]   
            
            if args[1] == "3":
                keystr = "条@我的微博"
            else:
                keystr = "条评论"

            try:                    
                print "notify update [" +args[0]+":t"+args[1]+"]", args[3]

                self.notis[args[0]+":t"+args[1]].update(args[2], args[3], args[4])
                self.notis[args[0]+":t"+args[1]].show()
            except:
            
                print "notify update error [" +args[0]+":t"+args[1]+"]", args[3]
                pass
                
        elif method == NOTIFY_SHARE_SIG_QUIT:    
            print NOTIFY_SHARE_SIG_QUIT
            gtk.main_quit()

    def run(self):
        """ Run. """
        gtk.main()

if __name__ == "__main__":     

    pynotify.init("qt_pynotify")

    #n = pynotify.Notification("asdf",
                          #"Yasd " +
                         # "adf")
    #n.set_urgency(pynotify.URGENCY_CRITICAL)

    #n.connect("closed", close_cb)

    #if not n.show():
    #    print "Failed to send notification"
    try:
        app = qt_pynotify()
        app.run()
    except:
        print "General failure."
        raise    
