
import os
import gtk
import osso
import hildondesktop

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *
from PyQt4.QtMaemo5 import *


NOTIFY_DBUS_NAME  ="cn.l32606.qt_pynotify"
NOTIFY_DBUS_IFACE ="cn.l32606.qt_pynotify"
NOTIFY_DBUS_PATH  ="/cn/l32606/qt_pynotify"

SH_DBUS_NAME  ="cn.l32606.maebo"
SH_DBUS_IFACE ="cn.l32606.maebo"
SH_DBUS_PATH  ="/cn/l32606/maebo"
SH_SHARE_SIG  ="send_via_service"

NOTIFY_SHARE_SIG_SHOW  ="show_notify"
NOTIFY_SHARE_SIG_UPDATE  ="update_notify"
NOTIFY_SHARE_SIG_QUIT  ="quit_app"

MCE_SERVICE = 'com.nokia.mce'
MCE_REQUEST_PATH =  '/com/nokia/mce/request'
MCE_REQUEST_IF = 'com.nokia.mce.request'
MCE_DEVICE_DISPSTATUS_GET = 'get_display_status'

def maebo_show(self):
    os.system('python /opt/maebo/maebo.py')
    
class MaeboStatusPlugin(hildondesktop.StatusMenuItem):
    def __init__(self):
    
        #import sys
        #f=open('/tmp/maebo.debug.log', 'at', buffering=1)
        #sys.stdout=f
        #sys.stderr=f
        hildondesktop.StatusMenuItem.__init__(self)
        self.osso_c = osso.Context(NOTIFY_DBUS_NAME, "0.0.1", False)
        self.osso_rpc = osso.Rpc(self.osso_c)
        
        maebo_status =self.osso_rpc.rpc_run(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_DEVICE_DISPSTATUS_GET, wait_reply=True, use_system_bus=True)        
        
        if maebo_status == "off":  
            return False
        
        self.osso_c = osso.Context(SH_DBUS_NAME, "0.0.1", False)
        self.osso_rpc = osso.Rpc(self.osso_c)
        self.osso_rpc.set_rpc_callback(NOTIFY_DBUS_NAME, NOTIFY_DBUS_PATH, NOTIFY_DBUS_IFACE, self.doSetMaeboStatus, self.osso_c)
        
        pixbuf = gtk.gdk.pixbuf_new_from_file("/opt/maebo/icons/maebo_status_default.png")
        self.set_status_area_icon(pixbuf)
        
        MaeboImage = gtk.image_new_from_file("/usr/share/pixmaps/maebo.png")
        button = gtk.Button()
        button.set_image(MaeboImage)
        button.connect("clicked", maebo_show)
        button.show_all()
        
        self.add(button)
        self.show_all()
        
    def doSetMaeboStatus(self, interface, method, args, user_data):
        
        print method
        
        if method == NOTIFY_SHARE_SIG_SHOW:
            print "pass"
            
        elif method == NOTIFY_SHARE_SIG_UPDATE:    
           # args[0] = account_idx, args[1] = optype, args[2] = nickname, args[3] = text, args[4] = iconstr
            #print NOTIFY_SHARE_SIG_UPDATE, args[0], args[1],args[2], args[3], args[4]   
            
            if args[1] == "3":
                self.keystr = "at me."
            else:
                self.keystr = "comments."

            try:                    
                print "notify update [" +args[0]+":t"+args[1]+"]", args[3]
                
                pixbuf = gtk.gdk.pixbuf_new_from_file("/opt/maebo/icons/maebo_status_update.png")
                self.set_status_area_icon(pixbuf)
                
                button = gtk.Button( label = "Maebo: " + args[3] )
                button.connect("clicked", maebo_show)
                button.show_all()
                
                self.add(button)
                self.show_all()
                
                return True
            except:
            
                print "notify update error [" +args[0]+":t"+args[1]+"]", args[3]
                pass
            
        elif method == NOTIFY_SHARE_SIG_QUIT:    
            print NOTIFY_SHARE_SIG_QUIT
            gtk.main_quit()
        
        
hd_plugin_type = MaeboStatusPlugin
