#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-

__author__="Michael/Binkcn/l32606"
__date__ ="$2011-09-04$"

import dbus
import dbus.glib
import dbus.service
import osso

import sys
import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import logging
from datetime import *
from UI import *
from Controller import Controller
#from Updater import *
from UpdaterSina import *
from UpdaterQQ import *
from weibopy.error import WeibopError
#from qqweibo.error import QWeiboError
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from flickcharm import FlickCharm
import shutil
import fnmatch

import ExifTags
from PIL import Image
from PIL.ExifTags import TAGS

import threading


# Define some constants
MCE_SIGNAL_NAME = 'sig_device_orientation_ind'
MCE_SIGNAL_IFACE = 'com.nokia.mce.signal'
MCE_SIGNAL_PATH = '/com/nokia/mce/signal'


MCE_SERVICE = 'com.nokia.mce'
MCE_REQUEST_PATH =  '/com/nokia/mce/request'
MCE_REQUEST_IF = 'com.nokia.mce.request'
MCE_DEVICE_ORIENTATION_GET = 'get_device_orientation'
MCE_DEVICE_DISPSTATUS_GET = 'get_display_status'
MCE_DEVICE_SCRLOCK_GET = 'get_tklock_mode'

ENABLE_LED = 'req_led_pattern_activate'
DISABLE_LED = 'req_led_pattern_deactivate'
VIBRATE  = 'req_vibrator_pattern_activate'
VIBRATE_PATTERN= 'PatternChatAndEmail'
LED_PATTERN ='PatternCommunicationSMS'# 'PatternCommunicationIM'

SH_DBUS_NAME  ="cn.l32606.maebo"
SH_DBUS_IFACE ="cn.l32606.maebo"
SH_DBUS_PATH  ="/cn/l32606/maebo"
SH_SHARE_SIG  ="send_via_service"

SESSION_DBUS_NAME  ="cn.l32606.maebo_session"
SESSION_DBUS_IFACE ="cn.l32606.maebo_session"
SESSION_DBUS_PATH  ="/cn/l32606/maebo_session"
SESSION_SHARE_SIG  ="show_window"

NOTIFY_DBUS_NAME  ="cn.l32606.qt_pynotify"
NOTIFY_DBUS_IFACE ="cn.l32606.qt_pynotify"
NOTIFY_DBUS_PATH  ="/cn/l32606/qt_pynotify"
NOTIFY_SHARE_SIG_SHOW  ="show_notify"
NOTIFY_SHARE_SIG_UPDATE  ="update_notify"
NOTIFY_SHARE_SIG_QUIT  ="quit_app"

_SM_AUTO_IDLE = 0
_SM_AUTO_CONNECTING = 1
_SM_AUTO_CONNECTED = 2



class MaoboApp(QApplication):
    def __init__(self, parent=None):
        print str(time.time()) + ": " + "MaoboApp __init__"
        self.logger = logging.getLogger('maebo')        
        self.logger.info("__initing__")
        
        super(MaoboApp, self).__init__(parent)
    # Get the system bus
        sysbus=dbus.Bus.get_system()

    # Connect the "handler" to the orientation changed signal of mce
        sysbus.add_signal_receiver(self.OrientationHandler, signal_name=MCE_SIGNAL_NAME, dbus_interface=MCE_SIGNAL_IFACE, path=MCE_SIGNAL_PATH)

        self.osso_c = osso.Context(SH_DBUS_NAME,"0.0.1",False)
        self.osso_rpc = osso.Rpc(self.osso_c)
        self.osso_rpc.set_rpc_callback(SH_DBUS_NAME, SH_DBUS_PATH, SH_DBUS_IFACE, self.send_via_service, self.osso_c)

        print str(time.time()) + ": " + "MaoboApp __init__ a" 
        self.charm = FlickCharm()

        #print str(time.time()) + ": " + "MaoboApp __init__ b"   
        self.controller=Controller()

        print str(time.time()) + ": " + "MaoboApp __init__ c"   
        
        self.updatersina=UpdaterSina(self.show_notice)
        self.sendersina=SenderSina(self.show_notice)
        self.updaterqq=UpdaterQQ(self.show_notice)
        self.senderqq=SenderQQ(self.show_notice)
        
        self.connect(self.updatersina, SIGNAL("finished(bool)"), self.update_finished)
        self.connect(self.sendersina, SIGNAL("finished(bool)"), self.send_finished)
        self.connect(self.updatersina, SIGNAL("show_notice(QString,int)"), self.show_notice)
        self.connect(self.sendersina, SIGNAL("show_notice(QString,int)"), self.show_notice)
        self.connect(self.updatersina, SIGNAL("cm_finished(bool)"), self.update_comments_finished)

        self.connect(self.updaterqq, SIGNAL("finished(bool)"), self.update_finished)
        self.connect(self.senderqq, SIGNAL("finished(bool)"), self.send_finished)
        self.connect(self.updaterqq, SIGNAL("show_notice(QString,int)"), self.show_notice)
        self.connect(self.senderqq, SIGNAL("show_notice(QString,int)"), self.show_notice)
        self.connect(self.updaterqq, SIGNAL("cm_finished(bool)"), self.update_comments_finished)

        self.currentStatus=None
        self.timelineType=None
        self.accounts=self.controller.get_all_accounts()
        self.websites=self.controller.get_all_websites()
        self.settings=self.controller.get_settings()
        
        self.currentAccount=None

        self.commentid_seed = 0
        self.create_accounts_window()
        if len(self.accounts)==0:
            self.create_default_window()
            self.defaultWin.show()
        else:
            self.accountsWin.show()

        #print str(time.time()) + ": " + "MaoboApp __init__ 1"  
        
        self.sendersina_service=SenderSina(self.show_notice)
        self.senderqq_service=SenderQQ(self.show_notice)

        #self.clean_temp_images("/home/user/.sharing/outbox")


        print str(time.time()) + ": " + "MaoboApp __init__ 2"
                 
        Utils.g_orietation=self.get_current_orientation()
        print Utils.g_orietation
        self.create_timeline_window()
        self.create_status_window()
        self.newStatusWin=None
        self.accountsManaForm=None
        self.newAccountForm=None

        self.init_unread_updaters()
        
        print "first threading start"
        self.sm_auto_update_unread = _SM_AUTO_IDLE
        self.t = threading.Timer(5.0, self.cb_update_unread_counts)
        self.t.start()
        print str(time.time()) + ": " + "MaoboApp __init__ 3"
        
        self.connect(self, SIGNAL("lastWindowClosed()"), self.lastWindowClosed)
          
    def lastWindowClosed(self):
        print "lastWindowClosed"        
        '''TODO: need to check the updaters state, and terminate them'''

          
    def init_unread_updaters(self):        

        self.unread_notifiers = {} #key = index of self.accounts
        self.unread_updaters = {} #key = accountid in database
        
        i = 0
        for ac in self.accounts:
            #print ac["id"], ac["website"], ac["nickname"]
            #print ac["auto_update"]
            
            if ac["website"] ==1:# and ac["auto_update"] == "True":
                self.unread_updaters[str(ac["id"])]=UpdaterSina(self.show_notice, accountId=ac["id"])
                self.unread_updaters[str(ac["id"])].OAuth(ac["username"],ac["password"])
                self.connect(self.unread_updaters[str(ac["id"])], SIGNAL("unread_finished(int)"), self.get_unead_finished)
            elif ac["website"] ==2:# and ac["auto_update"] == "True":    
                self.unread_updaters[str(ac["id"])]=UpdaterQQ(self.show_notice, accountId=ac["id"])
                self.unread_updaters[str(ac["id"])].OAuth(ac["username"],ac["password"])
                self.connect(self.unread_updaters[str(ac["id"])], SIGNAL("unread_finished(int)"), self.get_unead_finished)

            self.unread_notifiers[str(i)+":t"+str(Utils.TIMELINE_TYPE_MENTIONS)] = 0
            self.unread_notifiers[str(i)+":t"+str(Utils.TIMELINE_TYPE_COMMENTS)] = 0
            i = i + 1



    def change_current_timeline_view(self, account_idx, optype):
        #print "change_current_timeline_view"

        self.currentAccount = self.accounts[account_idx]
        
        if self.currentAccount["website"]==1:
            self.updater=self.updatersina
            self.sender=self.sendersina
        else:
            self.updater=self.updaterqq
            self.sender=self.senderqq
            
        try:
            self.updater.OAuth(self.currentAccount["username"],self.currentAccount["password"])
            self.sender.OAuth(self.currentAccount["username"],self.currentAccount["password"])
        except WeibopError,we:
            self.show_notice(we)

        self.timelineType=optype
        self.timelineWin.currentMenuIdx = optype - 2
        model = self.timelineWin.menuListView.model()
        self.timelineWin.menuListView.setCurrentIndex(model.index(optype - 2, 0))
        self.show_timeline_window()
        
        # clean unread counts
        if self.timelineWin.menuModel.need_clear_unread_count(self.timelineType):
            self.unread_updaters[str(self.currentAccount["id"])].initialize(self.currentAccount["id"], Utils.TIMELINE_TYPE_DEUNREAD, optype=self.timelineType) 
            self.unread_updaters[str(self.currentAccount["id"])].start()
        
        self.update_timeline()        
        
        self.timelineWin.menuModel.clear_unread_count(self.timelineType) 
        self.timelineWin.menuListView.hide()
        self.timelineWin.menuListView.show()

    def cb_update_unread_counts(self):
        #print "cb_update_unread_counts"
        
        conn_status = self.osso_rpc.rpc_run("com.nokia.icd", "/com/nokia/icd", "com.nokia.icd", "get_state", wait_reply=True, use_system_bus=True)
        #print "conn_status",conn_status

        if conn_status == 0 and self.settings["auto_conn"] != "---None---":
            #print "try to auto-connect internet - status: %s" % (self.sm_auto_update_unread)
            self.sm_auto_update_unread = _SM_AUTO_CONNECTING

            #dbus-send --type=method_call --system --dest=com.nokia.icd /com/nokia/icd com.nokia.icd.connect string:"d8a643a0-a0a6-4db2-9b87-759e6fd0f969" uint32:0
            ret=self.osso_rpc.rpc_run("com.nokia.icd", "/com/nokia/icd", "com.nokia.icd", "connect", \
                rpc_args=(self.settings["auto_conn"], 0), wait_reply=True, use_system_bus=True)

            self.t = threading.Timer(15, self.cb_update_unread_counts)
            self.t.start()
            return
        elif self.sm_auto_update_unread == _SM_AUTO_CONNECTING and conn_status == 1:
            #print "auto-connect internet succeeded"
            self.sm_auto_update_unread = _SM_AUTO_CONNECTED
        
        for acc in self.unread_updaters:
            #print "cb_update_unread_counts: "+acc
            if self.unread_updaters[acc].isRunning() != True:
                #print "cb_update_unread_counts: update unread counts"
                self.unread_updaters[acc].initialize(self.unread_updaters[acc].accountId,Utils.TIMELINE_TYPE_UNREAD)        
                self.unread_updaters[acc].start()

        if self.is_app_background_mode(): 
            self.t = threading.Timer(60*float(self.settings["updateinterval2"]), self.cb_update_unread_counts)
        else:
            self.t = threading.Timer(60*float(self.settings["updateinterval"]), self.cb_update_unread_counts)
            
        self.t.start()
            
    def send_notification(self, website, nickname, optype, account_idx, msgs):
        import pynotify

        #print self.accountsWin.isVisible()

        #diplay_status =self.osso_rpc.rpc_run(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_DEVICE_DISPSTATUS_GET, wait_reply=True, use_system_bus=True)  
        #scr_lock_status =self.osso_rpc.rpc_run(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_DEVICE_SCRLOCK_GET, wait_reply=True, use_system_bus=True)  

        if optype == Utils.TIMELINE_TYPE_MENTIONS:
            keystr = "条@我的新消息"
        else:
            keystr = "条新评论"
            
        if website==1:
            iconstr = "maebo_sina"
        else:
            iconstr = "maebo_qq"  

        if self.unread_notifiers[str(account_idx)+":t"+str(optype)] != 0 \
            and self.unread_notifiers[str(account_idx)+":t"+str(optype)] == msgs:
            return

        print "notify [" +str(account_idx)+":t"+str(optype)+"], msgs", msgs   
        self.unread_notifiers[str(account_idx)+":t"+str(optype)] = msgs      
        self.osso_rpc.rpc_run(NOTIFY_DBUS_NAME, NOTIFY_DBUS_PATH, \
            NOTIFY_DBUS_IFACE, NOTIFY_SHARE_SIG_SHOW, 
            rpc_args=(str(account_idx), str(optype), str(nickname), \
            nickname+"﻿收到"+str(msgs)+keystr, iconstr), wait_reply=False, use_system_bus=False)
            
        if self.settings["notify_led"] == "True":
            self.osso_rpc.rpc_run(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, ENABLE_LED, rpc_args=(LED_PATTERN,"",""),use_system_bus=True)            
        if self.settings["notify_vibra"] == "True":
            self.osso_rpc.rpc_run(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, VIBRATE, rpc_args=(VIBRATE_PATTERN,"",""),use_system_bus=True)            
        if self.settings["notify_sound"] == "True":
            bus = dbus.SessionBus()            
            proxy = bus.get_object('com.nokia.HildonSVNotificationDaemon', '/com/nokia/HildonSVNotificationDaemon')            
            interface = dbus.Interface(proxy,dbus_interface='com.nokia.HildonSVNotificationDaemon')            
            #interface.PlayEvent({'time': 0, 'category': 'email-message'}, "maebo")
            interface.PlayEvent({'time': 0, 'category': 'sms-message'}, "maebo")
            
  
    def rotate_image(self, dst_file):
        img = Image.open(dst_file)        
        try:
            print(img._getexif().items())
            #exif=dict((ExifTags.TAGS[k], v) for k, v in img._getexif().items())
            exifinfo = img._getexif()
            exif={}
            exif['Orientation'] = 1
            
            if exifinfo != None:
                for tag, value in exifinfo.items():
                    decoded = TAGS.get(tag, tag)
                    if decoded == 'Orientation':
                        exif[decoded] = value
    
            print exif['Orientation']
            if exif['Orientation'] == 1:
                return
                
            if exif['Orientation'] == 6:
                img=img.rotate(270, expand=True)
            elif exif[orientation] == 6 : 
                image=image.rotate(270, expand=True)
            elif exif[orientation] == 8 : 
                image=image.rotate(90, expand=True)
            elif exif[orientation] == 3 : 
                image=image.rotate(180, expand=True)
    
            img.save(dst_file, "JPEG")
        except:
            pass
            
        
    def send_via_service(self, interface, method, args, user_data):

        print "send_via_service"
        
        if method == SH_SHARE_SIG:
           # args[0] = filepath, args[1] = Title, args[2] = Discirption, args[3] = nickname
           # print args[0], args[1],args[2], args[3]

            dst_file = args[0] + ".jpg"
            shutil.copyfile(args[0], dst_file)  
            self.rotate_image(dst_file)

            if os.path.getsize(dst_file) >= 700*1000:
                self.show_notice("﻿图片超大，请调整大小", 0)
                return

            param={}
            param["status"]=""
            if args[1] != "":
                param["status"] = args[1] + ": "
            param["status"]=param["status"]+args[2]

            if param["status"] == "":
                param["status"] = "Share image. " + datetime.now().strftime("%Y-%m-%d %H:%M:%S")

            #print param["status"]
            
            if dst_file != None:
                param["pic"] = dst_file

            param["timelineType"] = None
            
            for account in self.accounts:
                if account["nickname"] == args[3]:
                    if account["website"]==1:
                        sender=self.sendersina_service
                    else:
                        sender=self.senderqq_service
            
                    try:
                        sender.OAuth(account["username"], account["password"])
                    except WeibopError,we:
                        self.show_notice(we)
                        
                    sender.initialize(account["id"],param)
        
                    self.show_notice("微博发送中...")
                    sender.start()    
        elif method == "top_application":
            print "top_application"
            self.accountsWin.activateWindow()
            self.accountsWin.show()
        elif method == "open_mentions":
            #args[0] = account_idx, args[1] = optype
            print "open_mentions", args[0], args[1]

            self.accountsWin.activateWindow()
            self.accountsWin.show()
            
            conn_status = self.osso_rpc.rpc_run("com.nokia.icd", "/com/nokia/icd", \
                "com.nokia.icd", "get_state", wait_reply=True, use_system_bus=True)
            print "conn_status",conn_status

            if conn_status == 0 and self.settings["auto_conn"] != "---None---":
                print "try to auto-connect internet - status: %s" % (self.sm_auto_update_unread)

                #dbus-send --type=method_call --system --dest=com.nokia.icd /com/nokia/icd com.nokia.icd.connect string:"d8a643a0-a0a6-4db2-9b87-759e6fd0f969" uint32:0
                ret=self.osso_rpc.rpc_run("com.nokia.icd", "/com/nokia/icd", "com.nokia.icd", "connect", \
                    rpc_args=(self.settings["auto_conn"], 0), wait_reply=True, use_system_bus=True)
            

            #print self.unread_notifiers[args[0]+":t"+args[1]].isVisible()
            self.unread_notifiers[args[0]+":t"+args[1]] = 0

            self.change_current_timeline_view(int(args[0]), int(args[1]))
            
        elif method == "clear_unread":
            #args[0] = account_idx, args[1] = optype
            print "clear_unread", args[0], args[1], "clean unread counts"
            
            self.unread_notifiers[args[0]+":t"+args[1]] = 0
        
            # clean unread counts
            #self.unread_updaters[str(self.accounts[int(args[0])]["id"])].initialize(self.accounts[int(args[0])]["id"], Utils.TIMELINE_TYPE_DEUNREAD, optype=int(args[1])) 
            #self.unread_updaters[str(self.accounts[int(args[0])]["id"])].start()
        else:    
            print "Not support method: " + method
            return
            
    def clean_temp_images(self, outbox_path):
        if os.path.isdir(outbox_path):
            paths = os.listdir(outbox_path)
            for path in paths:
                filePath = os.path.join(outbox_path, path)
                if os.path.isfile(filePath):
                    try:                        
                        if fnmatch.fnmatch(filePath,'*.jpg'):
                            print filePath
                            os.remove(filePath)
                    except os.error:
                        continue
 
    def get_current_orientation(self):
        '''
        f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
        x,y,z = [int(w) for w in f.readline().split()]
        f.close()
        
        if abs(x)<500: 
            print "landscape"
            return 0#LANDSCAPE
        else:
            print "portrait"
            return 1#PORTRAIT
       '''            
        #osso_c = osso.Context(SH_DBUS_NAME,"0.0.1",False) 
        orientation=None

        #rpc = osso.Rpc(osso_c)
        orientation =self.osso_rpc.rpc_run(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_DEVICE_ORIENTATION_GET, wait_reply=True, use_system_bus=True)       
        print orientation
        
        if orientation == 'landscape': 
            return 0
        elif orientation == "landscape (inverted)": 
            return 2
        elif orientation == 'portrait':
            return 1
        elif orientation ==  "portrait (inverted)":
            return 3
       

            
# Define a callback that gets called for orientation changes
    def OrientationHandler(self, orientation, stand, face, x, y, z):   
        #print "OrientationHandler"
        #print orientation
        if orientation == 'landscape': 
            Utils.g_orietation = 0
            self.timelineWin.switch(0)
            self.newStatusWin.switch(0)
            #print "landscape"
        elif orientation == "landscape (inverted)": 
            Utils.g_orietation = 2
            self.timelineWin.switch(2)
            self.newStatusWin.switch(2)
        elif orientation == 'portrait':
            Utils.g_orietation = 1
            self.timelineWin.switch(1)
            self.newStatusWin.switch(1)
            #print "portrait"
        elif orientation ==  "portrait (inverted)":
            Utils.g_orietation = 3
            self.timelineWin.switch(3)
            self.newStatusWin.switch(3)
        else:
            print "other orietation"
            
    def create_default_window(self):
        self.defaultWin=DefaultWindow(None)
        accountsManaAction = self.create_action(unicode("账户管理"), self.show_accounts_mana_form)
        settingAction=self.create_action(unicode("微博设置"), self.show_setting_form)
        delcacheAction=self.create_action(unicode("清理缓存"), self.delete_cache)
        aboutAction=self.create_action(unicode("关于软件"), self.show_about_form)
        self.menuBar=QMenuBar()
        self.add_actions(self.menuBar, (accountsManaAction,settingAction,delcacheAction,aboutAction))
        self.defaultWin.setMenuBar(self.menuBar)

    def create_accounts_window(self):
        self.accountsWin=AccountsWindow(None,self.accounts,self.websites, mode=self.settings["background"])
        self.connect(self.accountsWin.accountsListView,
                     SIGNAL("clicked(const QModelIndex&)"),
                     self.account_clicked)
                     
        accountsManaAction = self.create_action(unicode("账户管理"), self.show_accounts_mana_form)
        settingAction=self.create_action(unicode("微博设置"), self.show_setting_form)
        delcacheAction=self.create_action(unicode("清理缓存"), self.delete_cache)
        aboutAction=self.create_action(unicode("关于软件"), self.show_about_form)
        self.menuBar=QMenuBar()
        self.add_actions(self.menuBar, (accountsManaAction,settingAction,delcacheAction,aboutAction))
        self.accountsWin.setMenuBar(self.menuBar)

    def delete_cache(self):
        # delete cache images and data. befor 30 days.
        
        self.controller.del_status_by_cache()
        
        import os
        os.system('find '+Utils.THUMBNAIL_DIR+' -mtime +7 | xargs rm -rf')
        os.system('rm -rf '+Utils.LOG_FILE)
        
        self.show_notice("成功清理一周之前的图片、微博、以及日志数据缓存。")
        
    def account_clicked(self,index):
        self.logger.debug("account_clicked")
        row=index.row()
        self.currentAccount=self.accounts[row]
        #print self.currentAccount
        
        if self.currentAccount["website"]==1:
            self.updater=self.updatersina
            self.sender=self.sendersina
        else:
            self.updater=self.updaterqq
            self.sender=self.senderqq
            
        try:
            self.updater.OAuth(self.currentAccount["username"],self.currentAccount["password"])
            self.sender.OAuth(self.currentAccount["username"],self.currentAccount["password"])
        except WeibopError,we:
            self.show_notice(we)
            
        self.logger.debug(self.currentAccount["username"]+" choosed.")
        self.timelineType=Utils.TIMELINE_TYPE_FRIENDS
        self.timelineWin.currentMenuIdx = 0
        model = self.timelineWin.menuListView.model()
        self.timelineWin.menuListView.setCurrentIndex(model.index(0, 0))


        self.unread_updaters[str(self.currentAccount["id"])].initialize(self.currentAccount["id"],Utils.TIMELINE_TYPE_UNREAD)        
        self.unread_updaters[str(self.currentAccount["id"])].start()

        self.show_timeline_window()

    def create_menus_window(self):
        self.menus=Utils.build_menus()
        self.menusWin=MenusWindow(self.accountsWin,self.menus) #, self.currentAccount["nickname"])

        #self.connect(self.menusWin.menuListView,SIGNAL("clicked(const QModelIndex&)"),self.menu_clicked)


    def menu_clicked(self,index):
        #print "menu_clicked"
        self.logger.debug("menu_clicked")
        row=index.row()
        menu=self.timelineWin.menus[row]
        self.logger.debug(menu["name"]+" choosed.")
        value=menu["value"]
        
        if value==Utils.NEW_A_STATUS:
            model = self.timelineWin.menuListView.model()
            self.timelineWin.menuListView.setCurrentIndex(model.index(self.timelineWin.currentMenuIdx, 0))
            self.show_new_status_window()
        else:
            self.timelineWin.currentMenuIdx = index.row()
            self.timelineType=value      
            self.show_timeline_window()
            
    def on_timeline_window_closed(self):
        self.currentAccount = None

    def create_timeline_window(self):
        self.timelineWin=TimelineWindow(self.accountsWin, orientation=Utils.g_orietation)
        self.connect(self.timelineWin.statusesListView,SIGNAL("clicked(const QModelIndex&)"),self.status_clicked)
        self.connect(self.timelineWin.menuListView,SIGNAL("clicked(const QModelIndex&)"),self.menu_clicked)
        self.connect(self.timelineWin,SIGNAL("timelinwin_close()"),self.on_timeline_window_closed)
        
        self.updateOpe=Utils.build_an_operation(Utils.STATUS_OPE_TYPE_UPDATE,
                                          "Click to update",
                                          Utils.get_last_update_time_by_timeline_type(self.currentAccount,self.timelineType))
        self.moreOpe=Utils.build_an_operation(Utils.STATUS_OPE_TYPE_MORE,
                                        "Click to load more",None)
        self.gapOpe=Utils.build_an_operation(Utils.STATUS_OPE_TYPE_GAP,
                                        "Click to eliminate the gap",None)
        self.currentOpe=None

    def create_status_window(self):
        self.statusWin=StatusWindow(self.timelineWin)        
        self.connect(self.statusWin.statusesListView, SIGNAL("clicked(const QModelIndex&)"), self.cm_List_clicked)
        self.connect(self.statusWin.cmBtn, SIGNAL("clicked()"), self.cm_status_clicked)            

        self.connect(self.statusWin.rtBtn, SIGNAL("clicked()"), self.rt_a_status)
        self.connect(self.statusWin.cmtBtn, SIGNAL("clicked()"), self.comment_a_status)
        self.connect(self.statusWin.dmBtn, SIGNAL("clicked()"), self.dm_a_status)
        self.connect(self.statusWin.favBtn, SIGNAL("clicked()"), self.fav_a_status)
        self.connect(self.statusWin.ReplyBtn, SIGNAL("clicked()"), self.Reply_a_status)
        self.charm.activateOn(self.statusWin.statusContentView)

    def show_timeline_window(self):
        self.logger.debug("show_timeline_window")
        
        self.updateOpe["lastUpdated"]=Utils.get_last_update_time_by_timeline_type(self.currentAccount,self.timelineType)
        if self.timelineType==Utils.TIMELINE_TYPE_FAVOUR:
            self.logger.debug("load favorited statuses from db")
            self.statuses=self.controller.get_favorited_statuses_by_account(self.currentAccount["id"])
        else:
            self.statuses=self.controller.get_statuses_by_account(self.currentAccount["id"],self.timelineType)
#        statusCount=self.controller.get_status_count_by_account(1)
        if len(self.statuses)>0:
            #if the last one is a gap,remove it.
            lastOne=self.statuses[-1]
            if lastOne["if_gap"]==1:
                self.logger.debug("remove the gap because it is the last one.")
                #self.statuses.remove(lastOne)
            #don't provide loadmore for favorite timeline
            if self.timelineType!=Utils.TIMELINE_TYPE_FAVOUR:
                self.statuses.append(self.moreOpe)
        #don't provide update for favorite timeline
        if self.timelineType!=Utils.TIMELINE_TYPE_FAVOUR:
            self.statuses.insert(0,self.updateOpe)
        self.timelineWin.load_statuses(self.statuses)
        self.timelineWin.statusesListView.scrollToTop()        
        self.timelineWin.setWindowTitle(self.currentAccount["nickname"])
        self.timelineWin.show()
        self.timelineWin.switch(Utils.g_orietation)

    def status_clicked(self,index):
        self.logger.debug("status_clicked")
        row=index.row()
        status=self.statuses[row]

        try:
            type=status["type"]
            self.logger.debug("type:"+str(type))
            if type==Utils.STATUS_OPE_TYPE_UPDATE:
                self.update_timeline()
            elif type==Utils.STATUS_OPE_TYPE_MORE:
                self.load_more_timeline()
                
            # clean unread counts
            if self.timelineWin.menuModel.need_clear_unread_count(self.timelineType):
                self.unread_updaters[str(self.currentAccount["id"])].initialize(self.currentAccount["id"], Utils.TIMELINE_TYPE_DEUNREAD, optype=self.timelineType) 
                self.unread_updaters[str(self.currentAccount["id"])].start()

            self.timelineWin.menuModel.clear_unread_count(self.timelineType) 
            self.timelineWin.menuListView.hide()
            self.timelineWin.menuListView.show()
            
        except KeyError,ae:
            if status["if_gap"]==1:
                self.logger.debug("it is a gap")
                #if it is a gap, need to fetch statuses to fill it.
                if self.updater.isRunning():
                    self.logger.debug("updater is running!")
                    self.show_notice("后台运行中，请稍候重试")
                    return
                
                if self.currentAccount["website"]==1:
                    maxStatus=self.statuses[row-1]
                    sinceStatus=self.statuses[row+1]
                    maxId=maxStatus["id"]-1
                    sinceId=sinceStatus["id"]
                    self.currentOpe=self.gapOpe
                    self.gapRow=row
                    self.updater.initialize(self.currentAccount["id"],self.timelineType,sinceId,maxId,self.settings["updatenum"],self.settings["downpic"])
                else:
                    tmpStatus=self.statuses[row-1]
                    pagetime=tmpStatus["bmiddle_pic"]
                    self.currentOpe=self.gapOpe
                    self.gapRow=row
                    self.updater.initialize(self.currentAccount["id"],self.timelineType,1,pagetime,self.settings["updatenum"],self.settings["downpic"])
                
#                try:
#                    self.updater.basicAuth(Utils.APP_KEY,self.currentAccount["username"],self.currentAccount["password"])
#                except WeibopError,we:
#                    self.show_notice(we)
                self.show_notice("更新中...")
                self.set_windows_status(1)
                self.updater.start()
                
            else:
                self.logger.debug("show it")
                if self.timelineType !=Utils.TIMELINE_TYPE_COMMENTS: 
                    #so just show the status
                    self.currentStatus=status
                    self.show_status_window(status)
                else:
                    self.currentStatus=status
                    self.create_new_status_window(self.timelineWin)
                    if self.currentStatus["status"] != None:
                        self.newStatusWin.iOriginalID = self.currentStatus["status"]["id"]
                    else:
                        self.newStatusWin.iOriginalID = self.currentStatus["id"]
                    #print str(self.currentStatus["status"]["id"]) + ":" + self.currentStatus["status"]["text"]
                    self.newStatusWin.setWindowTitle(self.currentAccount["nickname"])
                    self.newStatusWin.load_status(self.currentStatus,Utils.TIMELINE_TYPE_COMMENTS, 1)
                    self.newStatusWin.show()
                
    def cm_List_clicked(self,index):
        self.logger.debug("cm_List_clicked")
        row=index.row()
        #print str(row)
        if row != 0:
            self.statusWin.ReplyBtn.setEnabled(True)
            self.statusWin.reply_status=self.statusWin.comment_statuses[row]
            #print self.statusWin.reply_status["id"]
            self.statusWin.iOriginalID = self.statusWin.status["id"]
            #print self.statusWin.iOriginalID
            


    def cm_status_clicked(self):
        self.logger.debug("status_clicked")
        #row=index.row()
        #status=self.statusWin.statuses[row]

        if self.statusWin.bCommentFlag == 0:
            try:
            #type=status["type"]
            #self.logger.debug("type:"+str(type))
            # if type==Utils.STATUS_OPE_TYPE_COMMENT:
               self.update_comments()
               
            except KeyError,ae:
                pass
        else:
            self.statusWin.hide_comments()
        

    def update_comments(self):
        self.logger.debug("update_comments")
        if self.updater.isRunning():
            self.logger.debug("updater is running!")
            self.show_notice("后台运行中，请稍候重试")
            return
        self.statusWin.commentsOpe["name"]="updating, please wait"
        self.statusWin.commentsOpe["lastUpdated"]=None
        self.statusWin.load_status(self.settings["down_orgpic"])
        self.statusWin.setWindowTitle(self.currentAccount["nickname"])
        self.statusWin.currentOpe=self.statusWin.commentsOpe
        
        if self.currentAccount["website"]==1:
            sinceId=None
            if len(self.statuses)>1:
                latestStatus=self.statuses[1]
                sinceId=latestStatus["id"]
                self.logger.debug("sinceId:"+str(sinceId))
            
            self.updater.initialize(self.currentAccount["id"],Utils.TIMELINE_TYPE_ST_COMMENTS,self.statusWin.status["id"],None,self.settings["updatenum"],self.settings["downpic"])
        else:
            pageflag=0
            pagetime=0
            
            # rem for binkcn 0926
            #if len(self.statuses)>1:
            #    latestStatus=self.statuses[1]
            #    lasetime=int(latestStatus["bmiddle_pic"])
            
                #import time
                #nowtime = int(time.time())
                #timediff = nowtime - lasetime
                    #if timediff <= 86400:
                    #    pageflag=2
                    #    pagetime=lasetime
            print self.statusWin.status["id"]
            print self.statusWin.status["user"]["name"]
            self.updater.initialize(self.currentAccount["id"],Utils.TIMELINE_TYPE_ST_COMMENTS,pageflag,pagetime,self.settings["updatenum"],self.settings["downpic"],self.statusWin.status["id"])
        
        self.show_notice("更新中...")
        self.set_windows_status(1)
        self.updater.start()

    def update_timeline(self):
        self.logger.debug("update_fridends_timeline")
        if self.updater.isRunning():
            self.logger.debug("updater is running!")
            self.show_notice("后台运行中，请稍候重试")
            return
        self.updateOpe["name"]="updating, please wait"
        self.updateOpe["lastUpdated"]=None
        self.timelineWin.load_statuses(self.statuses)
        self.timelineWin.setWindowTitle(self.currentAccount["nickname"])
        self.currentOpe=self.updateOpe
        
        if self.currentAccount["website"]==1:
            sinceId=None
            if len(self.statuses)>1:
                latestStatus=self.statuses[1]
                sinceId=latestStatus["id"]
                self.logger.debug("sinceId:"+str(sinceId))
            
            self.updater.initialize(self.currentAccount["id"],self.timelineType,sinceId,None,self.settings["updatenum"],self.settings["downpic"])
        else:
            pageflag=0
            pagetime=0
    	    
    	    # rem for binkcn 0926
    	    #if len(self.statuses)>1:
    	    #    latestStatus=self.statuses[1]
    	    #    lasetime=int(latestStatus["bmiddle_pic"])
    	        
    	        #import time
    	        #nowtime = int(time.time())
    	        #timediff = nowtime - lasetime
    	        #if timediff <= 86400:
    	        #    pageflag=2
    	        #    pagetime=lasetime
    	            
            self.updater.initialize(self.currentAccount["id"],self.timelineType,pageflag,pagetime,self.settings["updatenum"],self.settings["downpic"])
        
        self.show_notice("更新中...")
        self.set_windows_status(1)
        self.updater.start()
        
    def checkExits(self, newsStatus):
        for tmpStatus in self.statuses:
            if len(tmpStatus)>5:
                #print "=========================================="
                #print "Debug!"
                #print str(newsStatus["id"]) + " -> " + str(tmpStatus["id"])
                if tmpStatus["id"]==newsStatus["id"]:
                    #print "Remove!"
                    return 1
                
        return 0
        
    def is_app_background_mode(self):
    
        if self.activeWindow() == None:
            return True
            
        diplay_status =self.osso_rpc.rpc_run(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, \
            MCE_DEVICE_DISPSTATUS_GET, wait_reply=True, use_system_bus=True) 
            
        if diplay_status == "off":  
            return True

        return False
           

        
    def get_unead_finished(self,accountid):
        #print "get_unead_finished, id", accountid

        unread_counts = self.unread_updaters[str(accountid)].unread_counts
        
        #for n in unread_counts:
        #    print n
        #    print unread_counts[n]

        account_idx = 0
        for acc in self.accounts:
            if acc["id"] == accountid:
                break
            account_idx = account_idx + 1

        send_all = True
        if send_all == True or self.currentAccount == None or accountid != self.currentAccount["id"] \
            or self.is_app_background_mode():    
            account_idx = 0
            for acc in self.accounts:
                if acc["id"] == accountid:
                    break
                account_idx = account_idx + 1

            if acc["auto_update"] == "True" and unread_counts["mentions"] > 0:
                self.send_notification(acc["website"], acc["nickname"], \
                    Utils.TIMELINE_TYPE_MENTIONS, account_idx, unread_counts["mentions"])
        
            if acc["auto_update"] == "True" and unread_counts["comments"] > 0:
                self.send_notification(acc["website"], acc["nickname"], \
                    Utils.TIMELINE_TYPE_COMMENTS, account_idx, unread_counts["comments"])

        if self.currentAccount != None and accountid == self.currentAccount["id"]:
            self.timelineWin.menuModel.set_unread_counts(unread_counts)
            self.timelineWin.menuListView.hide()
            self.timelineWin.menuListView.show()

        for acc in self.unread_updaters:
            if self.unread_updaters[acc].isRunning() == True and acc != str(accountid):
                #print "self.unread_updaters, ", acc, "is running"
                return
           #elif self.unread_updaters[acc].isRunning() != True:
                #print "self.unread_updaters, ", acc, "is not running"
                
        if self.sm_auto_update_unread == _SM_AUTO_CONNECTED and self.is_app_background_mode():  
            print "try to auto-disconnect internet"
            bus=dbus.SystemBus()
            icd2_obj = bus.get_object('com.nokia.icd2', '/com/nokia/icd2') 
            icd2_iface = dbus.Interface(icd2_obj, 'com.nokia.icd2')
            icd2_iface.disconnect_req(dbus.UInt32(32768))
            self.sm_auto_update_unread = _SM_AUTO_IDLE

        
    def update_comments_finished(self,completed):
        #print "update_comments_finished"
        self.logger.debug("update_comments_finished")
        self.set_windows_status(0)
        newStatuses=self.updater.timeline
        
        self.statusWin.commentsOpe["name"]="Comments"
        self.statusWin.commentsOpe["lastUpdated"]=None
        
        if newStatuses!=None and len(newStatuses)>0:
            #newStatuses.extend(self.statusWin.comment_statuses)
            for line in newStatuses:
                self.commentid_seed = self.commentid_seed + 1
                line["status_id"] = (self.commentid_seed ) % 65535
            newStatuses.insert(0, self.statusWin.commentsOpe)   
            self.statusWin.comment_statuses=newStatuses

            self.statusWin.setWindowTitle(self.currentAccount["nickname"])
            self.statusWin.load_status(self.settings["down_orgpic"])
        else:
            self.statusWin.load_status(self.settings["down_orgpic"])
                       
        self.statusWin.currentOpe=None
        
    def update_finished(self,completed):
        #print "update_finished"
        self.logger.debug("update_finished")
        self.set_windows_status(0)
        newStatuses=self.updater.timeline

        # parse remove exist. for tencent.
        if self.currentAccount["website"] == 2:
            tmpStatuses = []
            for newStatus in newStatuses:
                tmpStatuses.append(newStatus)
            
            for newStatus in tmpStatuses:
                if self.checkExits(newStatus)==1:
                    newStatuses.remove(newStatus)
                    
        if self.unread_updaters[str(self.currentAccount["id"])].isRunning() != True:
            print "update_finished: update unread counts"
            self.unread_updaters[str(self.currentAccount["id"])].initialize(self.currentAccount["id"],Utils.TIMELINE_TYPE_UNREAD)        
            self.unread_updaters[str(self.currentAccount["id"])].start()

        if self.currentOpe==self.updateOpe:
            #update the lastUpdateTime for the updateOpe and account
            now=datetime.now()
            self.currentAccount=Utils.set_last_update_time_by_timeline_type(self.currentAccount, self.timelineType, now)
            self.controller.save_an_account(self.currentAccount)
            self.updateOpe["name"]="Click to update"
            self.updateOpe["lastUpdated"]=Utils.get_last_update_time_by_timeline_type(self.currentAccount, self.timelineType)
        elif self.currentOpe==self.moreOpe:
            self.moreOpe["name"]="Click to load more"
        
        if newStatuses!=None and len(newStatuses)>0:
            if self.currentOpe==self.updateOpe:
                self.statuses.remove(self.updateOpe)
                
                if len(newStatuses)==int(self.settings["updatenum"]) and len(self.statuses)>1:
                    self.logger.debug("add a gap status")
                    
                    gapStatus=Utils.build_a_gap_status(self.currentAccount["id"])
                    gapStatus["id"]=newStatuses[-1]["id"]-1
                    gapStatus["created_at"]=self.getMinCreatedAt(newStatuses,self.currentAccount["website"])-timedelta(seconds=1)
                    newStatuses.append(gapStatus)
                
                self.controller.save_statuses(self.currentAccount["id"],newStatuses,self.timelineType)

                if len(self.statuses)==0:
                    self.logger.debug("add the loadMore operation to the end")
                    self.statuses.append(self.moreOpe)

                newStatuses.extend(self.statuses)
                self.statuses=newStatuses

                self.statuses.insert(0,self.updateOpe)
                self.timelineWin.load_statuses(self.statuses)
                self.timelineWin.setWindowTitle(self.currentAccount["nickname"])
            elif self.currentOpe==self.moreOpe:
                repeatOne=newStatuses[0]
                newStatuses.remove(repeatOne)
                if len(newStatuses)>0:
                    self.controller.save_statuses(self.currentAccount["id"],newStatuses,self.timelineType)
                    self.statuses.remove(self.moreOpe)
                    self.statuses.extend(newStatuses)
                    self.statuses.append(self.moreOpe)
                    self.timelineWin.load_statuses(self.statuses)
                    self.timelineWin.setWindowTitle(self.currentAccount["nickname"])
            elif self.currentOpe==self.gapOpe:
                repeatOne=newStatuses[0]
                row=self.gapRow
                gapStatus=self.statuses[row]
                self.controller.del_status_by_id(self.currentAccount["id"],gapStatus["id"])
                if len(newStatuses)==int(self.settings["updatenum"]):
                    self.logger.debug("add a gap status")
                    
                    newgapStatus=Utils.build_a_gap_status(self.currentAccount["id"])
                    newgapStatus["id"]=newStatuses[-1]["id"]-1
                    newgapStatus["created_at"]=self.getMinCreatedAt(newStatuses,self.currentAccount["website"])-timedelta(seconds=1)
                    newStatuses.append(newgapStatus)
                self.controller.save_statuses(self.currentAccount["id"],newStatuses,self.timelineType)

                #remove the old gap and insert the new ones into the gap.
                self.statuses.remove(gapStatus)
                i=-1
                for newOne in newStatuses:
                    i+=1
                    self.statuses.insert(row+i,newOne)
                
                self.timelineWin.load_statuses(self.statuses)
                self.timelineWin.setWindowTitle(self.currentAccount["nickname"])
        else:
            self.timelineWin.load_statuses(self.statuses)
            
        if self.activeWindow() != self.timelineWin and self.activeWindow() != self.accountsWin:
            self.activeWindow().close()
        
        self.currentOpe=None
        
    def getMinCreatedAt(self, newstatuses, website):
        mincreatedat = None
        
        if website==1:
            minid = 8353251501876959
            for newstatus in newstatuses:
                timenum = int(newstatus["id"])
                if timenum < minid:
                    minid = timenum
                    mincreatedat = newstatus["created_at"]
        else:
            mintimenum = 3316874565
            for newstatus in newstatuses:
                timenum = int(newstatus["bmiddle_pic"])
                if timenum < mintimenum:
                    mintimenum = timenum
                    mincreatedat = newstatus["created_at"]
                
        return mincreatedat

    def load_more_timeline(self):
        self.logger.debug("load_more_timeline")
        oldestStatus=self.statuses[-2]
        pagetime=oldestStatus["created_at"]
        moreStatuses=self.controller.get_statuses_by_account_qq(self.currentAccount["id"],self.timelineType,1,pagetime)
        self.logger.debug(moreStatuses)
        #if there are no older statuses in db, need to fetch from server.

        if len(moreStatuses)==0:
            #for favorite page, do not fetch from server.
            if self.timelineType==Utils.TIMELINE_TYPE_FAVOUR:
                return
            if self.updater.isRunning():
                self.logger.debug("updater is running!")
                self.show_notice("后台运行中，请稍候重试")
                return
            self.moreOpe["name"]="loading, please wait"
            self.currentOpe=self.moreOpe
            self.timelineWin.load_statuses(self.statuses)
            self.timelineWin.setWindowTitle(self.currentAccount["nickname"])
            
            if self.currentAccount["website"]==1:
                oldestStatus=self.statuses[-2]
                maxId=oldestStatus["id"]
                self.logger.debug("maxId:"+str(maxId))
                self.updater.initialize(self.currentAccount["id"],self.timelineType,None,maxId,self.settings["updatenum"],self.settings["downpic"])
            else:
                oldestStatus=self.statuses[-2]
                pagetime=oldestStatus["bmiddle_pic"]
    	        pageflag=1
                self.updater.initialize(self.currentAccount["id"],self.timelineType,pageflag,pagetime,self.settings["updatenum"],self.settings["downpic"])
            
            
#            try:
#                self.updater.basicAuth(Utils.APP_KEY,self.currentAccount["username"],self.currentAccount["password"])
#            except WeibopError,we:
#                self.show_notice(we)
            self.show_notice("更新中...")
            self.set_windows_status(1)
            self.updater.start()
        #just load the statuses from db
        else:
            #if the last one is a gap,remove it.
            lastOne=moreStatuses[-1]
            #if lastOne["if_gap"]==1:
            #    moreStatuses.remove(lastOne)
            moreOpe=self.statuses[-1]
            self.statuses.remove(moreOpe)
            self.statuses.extend(moreStatuses)
            self.statuses.append(moreOpe)
            self.timelineWin.load_statuses(self.statuses)
            self.timelineWin.setWindowTitle(self.currentAccount["nickname"])


    def load_more_timeline_favorite(self):
        pass

    def show_status_window(self,status):
        #print "show_status_window"    
        #print status["id"]
        
        #if self.statusWin.status == None or self.statusWin.status["id"]!=status["id"]:
        self.statusWin.status=status
        self.statusWin.comment_statuses=[]
            
        self.statusWin.show()
        self.statusWin.load_status(self.settings["down_orgpic"])
        self.statusWin.setWindowTitle(self.currentAccount["nickname"])
        #self.statusWin.switch(self.orientation)
        self.statusWin.show()
        self.statusWin.repaint()

    def create_new_status_window(self,parent):
        self.newStatusWin=NewStatusWindow(parent, Utils.g_orietation)
        self.connect(self.newStatusWin.sendBtn,
                     SIGNAL("clicked()"),
                     self.send_a_status)


    def show_new_status_window(self,status=None):
        self.create_new_status_window(self.timelineWin)
        self.newStatusWin.setWindowTitle(self.currentAccount["nickname"])
        self.newStatusWin.load_status(None, None)
        self.newStatusWin.switch(Utils.g_orietation)
        self.newStatusWin.show()

    def rt_a_status(self):
        self.create_new_status_window(self.statusWin)
        self.newStatusWin.setWindowTitle(self.currentAccount["nickname"])
        self.newStatusWin.load_status(self.currentStatus,Utils.TIMELINE_TYPE_MENTIONS)
        self.newStatusWin.show()

    def comment_a_status(self):
        self.create_new_status_window(self.statusWin)
        self.newStatusWin.setWindowTitle(self.currentAccount["nickname"])
        self.newStatusWin.load_status(self.currentStatus,Utils.TIMELINE_TYPE_COMMENTS)
        
        self.newStatusWin.show()
        
    def Reply_a_status(self):
        try:
            type=self.statusWin.reply_status["type"]
        except:
            if self.statusWin.reply_status != None:
                self.create_new_status_window(self.statusWin)
                self.newStatusWin.iOriginalID = self.statusWin.iOriginalID
                self.newStatusWin.setWindowTitle(self.currentAccount["nickname"])
                self.newStatusWin.load_status(self.statusWin.reply_status,Utils.TIMELINE_TYPE_COMMENTS, 1)
                self.newStatusWin.show()

        
    def dm_a_status(self):
        self.create_new_status_window(self.statusWin)
        self.newStatusWin.load_status(self.currentStatus,Utils.TIMELINE_TYPE_DM)
        self.newStatusWin.show()

    def fav_a_status(self):
        #just fav it locally!!!
        favorited=self.currentStatus["favorited"]
        if favorited==None:
            favorited=0
        fav=1-favorited
        self.controller.favour_a_status(self.currentAccount["id"],self.currentStatus,fav)
        self.currentStatus["favorited"]=fav
        self.statusWin.change_favBtn_text(fav)

    def send_a_status(self):
        self.logger.debug("send_a_status")
        param=self.newStatusWin.output_param()
        if self.sender.isRunning():
            self.logger.debug("sender is running!")
            self.show_notice("后台运行中，请稍候重试")
            return
        self.newStatusWin.enable_send(False)
        
        #parse sina comments.
        #if self.currentStatus["if_comments"]==1:
        #    if self.currentStatus["bmiddle_pic"]==None:
        #        param["cid"]=int(param["id"])
        #        param["id"]=int(currentStatus["if_dm"])
        #    else:
        #        if len(self.currentStatus["bmiddle_pic"])!=10:
        #            param["cid"]=int(param["id"])
        #            param["id"]=int(currentStatus["if_dm"])
        
        #print "debug!"
        #print param
        
        self.sender.initialize(self.currentAccount["id"],param)
        
        self.show_notice("微博发送中...")
        self.set_windows_status(1)
        self.sender.start()

    def send_finished(self,completed):
        self.logger.debug("send_finished")
        self.set_windows_status(0)
        self.newStatusWin.enable_send(True)
        if completed:
#            self.show_notice("微博已成功发送",0)
            self.newStatusWin.hide()


    def create_accounts_mana_form(self,accounts):
        self.accountsManaForm=AccountsManaForm(accounts,self.websites,self.accountsWin)
        self.connect(self.accountsManaForm.addButton,
                     SIGNAL("clicked()"),
                     self.add_an_account)
        self.connect(self.accountsManaForm.editButton,
                     SIGNAL("clicked()"),
                     self.edit_an_account)
        self.connect(self.accountsManaForm.delButton,
                     SIGNAL("clicked()"),
                     self.del_an_account)

    def show_accounts_mana_form(self):
        self.accounts=self.controller.get_all_accounts()
        if self.accountsManaForm==None:
            self.create_accounts_mana_form(self.accounts)
        else:
            self.accountsManaForm.update_accounts(self.accounts)
        self.accountsManaForm.show()

    def create_new_account_form(self,account):
        self.newAccountForm=NewAccountForm(self.websites,account,self.accountsManaForm)
        self.connect(self.newAccountForm.confirmButton,
                     SIGNAL("clicked()"),
                     self.save_an_account)

    def show_new_account_form(self,account):
        if self.newAccountForm==None:
            self.create_new_account_form(account)
        else:
            self.newAccountForm.update_account(account)
        self.newAccountForm.show()


    def add_an_account(self):
        account=Utils.build_an_empty_account()
        self.show_new_account_form(account)
        self.newAccountForm.setWindowTitle(unicode("添加账户"))

    def edit_an_account(self):
        index=self.accountsManaForm.get_selected()
        if index==-1:
            self.show_notice("请选择需要编辑的账户")
        else:
            account=self.accounts[index]
            self.show_new_account_form(account)
            self.newAccountForm.setWindowTitle(unicode("编辑账户"))

    def save_an_account(self):
        account=self.newAccountForm.output_account(self.show_notice)
        if account!=None:
            self.controller.save_an_account(account)

            self.newAccountForm.hide()
            if self.defaultWin != None:
                self.defaultWin.hide()
            self.accountsWin.show()
            self.show_accounts_mana_form()       
            self.init_unread_updaters()            
            self.accountsModel=AccountsModel(self.accounts,self.websites)
            self.accountsWin.accountsListView.setModel(self.accountsModel)


    def del_an_account(self):
        index=self.accountsManaForm.get_selected()
        if index==-1:
            self.show_notice("请选择需要删除的账户")
            return
        else:
            account=self.accounts[index]
            
            if self.currentAccount!=None:
                if self.currentAccount["id"]==account["id"] and self.updater.isRunning():
                    self.show_notice("该账户正在进行更新操作，请稍候")
                    return
            website=None
            for web in self.websites:
                if web["id"]==account["website"]:
                    website=web
                    break
            self.delAccountForm=DeleteAccountForm(account,website,self.accountsWin)
            self.connect(self.delAccountForm.confirmButton,
                     SIGNAL("clicked()"),
                     self.del_an_account_confirmed)
            self.delAccountForm.show()

    def del_an_account_confirmed(self):
        account=self.delAccountForm.account
        self.controller.delete_an_account(account)
        self.show_notice("账号已删除")
        self.delAccountForm.hide()
        self.show_accounts_mana_form()
        self.accountsModel=AccountsModel(self.accounts,self.websites)
        self.accountsWin.accountsListView.setModel(self.accountsModel)

    def show_setting_form(self):
        self.settingForm=SettingForm(self.accountsWin, self.settings)
        self.connect(self.settingForm.confirmButton,
                     SIGNAL("clicked()"),
                     self.save_settings)
        self.settingForm.show()
        
    def save_settings(self):
        settings=self.settingForm.output_account(self.show_notice)
        if settings!=None:
            settings = self.controller.save_settings(settings)
            if settings!=None:
                self.settings=settings
                #self.show_notice("成功保存微博设置")
        if self.accountsWin != None:
            self.accountsWin.set_running_mode(self.settings["background"])

        self.settingForm.hide()

    def show_about_form(self):
        aboutForm=AboutForm(self.accountsWin)
        aboutForm.show()

#    def show_notice(self,message):
#        print message

    def show_notice(self,message,timeout=QMaemo5InformationBox.DefaultTimeout):
        QMaemo5InformationBox.information(None,"\n"+unicode(message)+"\n",timeout)

    def set_windows_status(self,busy):
        if busy>0:
            self.accountsWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            #self.menusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            self.timelineWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            self.statusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            if self.newStatusWin!=None:
                self.newStatusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
        else:
            self.accountsWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            #self.menusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            self.timelineWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            self.statusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            if self.newStatusWin!=None:
                self.newStatusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)


    def create_action(self, text, slot=None, shortcut=None, icon=None,
                  tip=None, checkable=False, signal="triggered()"):
        action = QAction(text, self)
        if icon is not None:
            action.setIcon(QIcon(":/%s.png" % icon))
        if shortcut is not None:
            action.setShortcut(shortcut)
        if tip is not None:
            action.setToolTip(tip)
        if slot is not None:
            self.connect(action, SIGNAL(signal), slot)
        if checkable:
            action.setCheckable(True)
        return action

    def add_actions(self, target, actions):
        for action in actions:
            if action is None:
                target.addSeparator()
            else:
                target.addAction(action)
                
class MaeboService(dbus.service.Object):
    def __init__(self, app):
        self.app = app
        bus_name = dbus.service.BusName(SESSION_DBUS_NAME, bus = dbus.SessionBus())
        dbus.service.Object.__init__(self, bus_name, SESSION_DBUS_PATH)

    @dbus.service.method(dbus_interface=SESSION_DBUS_IFACE)
    def show_window(self):
        self.app.accountsWin.activateWindow()   
        self.app.accountsWin.show()  
        print "show_window"

def main():    
    if dbus.SessionBus().request_name(SESSION_DBUS_NAME) != dbus.bus.REQUEST_NAME_REPLY_PRIMARY_OWNER:
    #if False:
        print "application already running"
        method = dbus.SessionBus().get_object(SESSION_DBUS_NAME, SESSION_DBUS_PATH).get_dbus_method("show_window")
        method()
    else:
	    print str(time.time()) + ": " + "main"
	    dir=Utils.DATA_FILE_PATH
	    if os.access(dir, os.W_OK) == 0:
	        os.mkdir(dir)
	    dir=Utils.THUMBNAIL_DIR
	    if os.access(dir, os.W_OK) == 0:
	        os.mkdir(dir)
	    dir=Utils.AVATAR_DIR
	    if os.access(dir, os.W_OK) == 0:
	        os.mkdir(dir)
	    # set up logging to file - see previous section for more details
	    logging.basicConfig(level=logging.INFO,
	                        format='%(asctime)s %(name)-12s %(levelname)-8s %(message)s',
	                        datefmt='%y-%m-%d %H:%M',
	                        filename=Utils.LOG_FILE,
	                        filemode='a')
	    # define a Handler which writes INFO messages or higher to the sys.stderr
#    console = logging.StreamHandler()
#    console.setLevel(logging.DEBUG)
#    # set a format which is simpler for console use
#    formatter = logging.Formatter('%(asctime)s %(name)-12s %(levelname)-8s %(message)s')
#    # tell the handler to use this format
#    console.setFormatter(formatter)
#    # add the handler to the root self.logger
#    logging.getLogger('').addHandler(console)
	    reload(sys)
	    sys.setdefaultencoding('utf8')
	    QTextCodec.setCodecForCStrings(QTextCodec.codecForName("UTF-8"))
	    print str(time.time()) + ": " + "before MaoboApp"
	    app = MaoboApp(sys.argv)
	    app.setOrganizationName("SkyBlue Works")
	    app.setOrganizationDomain("michaelwong.cn")
	    app.setApplicationName("maebo")
	    print str(time.time()) + ": " + "before app.exec_"

	    service = MaeboService(app)

	    app.exec_()
	    print "after app.exec_"

	    app.t.cancel()
#def on_notification_closed (notification, user_data, sbc):
#    notification.close()
#    print "on_state_reason_notification_closed"


main()

