#include <QHBoxLayout>
#include <QPushButton>
#include <QProcess>
#include <QDebug>

#include <QTextEdit>
#include <QFile>
#include <QTextStream>

#include "launcher.h"
#include "mainwindow.h"

#if defined(Q_WS_MAEMO_5)
#include <QAbstractKineticScroller>
#endif

Launcher::Launcher(MainWindow *main)
{
	m_layout = new QHBoxLayout;
	setLayout(m_layout);

	m_buttons[PASSWD_BUTTON] = new QPushButton(tr("Developer\nPassword"));
	m_buttons[METHER_BUTTON] = new QPushButton(tr("Usb\nNetworking"));
	m_buttons[XTERM_BUTTON] = new QPushButton(tr("Developer\nTerminal"));
	m_buttons[HELP_BUTTON] = new QPushButton(tr("Help"));

	m_helpwindow = 0;

#if 0
	for (int i = 0; i < NUM_BUTTONS; i++)
	    m_buttons[i]->setSizePolicy(QSizePolicy::Preferred,
					QSizePolicy::Expanding);
#endif
	//m_buttons[XTERM_BUTTON]->setEnabled(false);
	m_layout->addWidget(m_buttons[METHER_BUTTON]);
	m_layout->addWidget(m_buttons[PASSWD_BUTTON]);
	m_layout->addWidget(m_buttons[XTERM_BUTTON]);
	m_layout->addWidget(m_buttons[HELP_BUTTON]);

	connect(m_buttons[PASSWD_BUTTON], SIGNAL(pressed()),
		main, SLOT(showPasswd()));
	connect(m_buttons[METHER_BUTTON], SIGNAL(pressed()),
		main, SLOT(showUsbManage()));
	connect(m_buttons[XTERM_BUTTON], SIGNAL(pressed()),
		this, SLOT(startXTerm()));
	connect(m_buttons[HELP_BUTTON], SIGNAL(pressed()),
		this, SLOT(showHelp()));
}

void Launcher::activateButtons(bool activate)
{
    for (int i = 0; i < NUM_BUTTONS; i++)
	m_buttons[i]->setEnabled(activate);
}

void
Launcher::startXTerm(void)
{
	QProcess *xterm = new QProcess;

	xterm->startDetached(QString("./xterm.sh"));
	//xterm->start(QString("./xterm.sh", (QStringList)0);

	delete xterm;
}


class HelpWindow : public QTextEdit
{
public:
    HelpWindow(QTextEdit ** ref) : QTextEdit() { this->ref = ref; }
private:
    QTextEdit ** ref;
    void closeEvent(QCloseEvent * event);
};

void HelpWindow::closeEvent(QCloseEvent * event)
{
    (void)event;
    delete *ref; // or this. *ref should == this
    *ref = 0;
}

void Launcher::showHelp(void)
{
    if (m_helpwindow != 0)
	return;

    QFile file("help.html");
    if (!file.open(QFile::ReadOnly | QFile::Text))
	return;
    QTextStream in(&file);

    m_helpwindow = new HelpWindow(&m_helpwindow);
    m_helpwindow->setWindowTitle(tr("Mad Developer Help"));

    // many of this stuff could be done in constructor... but this is
    // one-shot; no need to create separate constructor function...
    m_helpwindow->setReadOnly(true);
    m_helpwindow->setHtml(in.readAll());
#if defined(Q_WS_MAEMO_5)
    QAbstractKineticScroller *scroller
	= m_helpwindow->property("kineticScroller")
	.value<QAbstractKineticScroller *>();
    if (scroller) scroller->setEnabled(true);
#else
    m_helpwindow->setMinimumSize(600, 400);
#endif
    m_helpwindow->show();
}
