#include <QGridLayout>
#include <QPushButton>
#include <QByteArray>
#include <QLabel>

#include "mainwindow.h"
#include "processrunner.h"
#include "usbmanage.h"

static const QString script("./usbmodule.sh");

UsbManage::UsbManage(MainWindow *main)
	:  m_main(main)
{
	m_runner = new ProcessRunner;
	m_layout = new QGridLayout;
	setLayout(m_layout);

	m_buttons[LOAD_E_BUTTON] = new QPushButton(tr("Windows\nNetwork"));
	m_buttons[LOAD_N_BUTTON] = new QPushButton(tr("Unix\nNetwork"));
	m_buttons[LOAD_F_BUTTON] = new QPushButton(tr("Mass\nStorage"));
	m_buttons[CLOSE_BUTTON] = new QPushButton(tr("Close"));
	m_txt = new QLabel(tr("USB module in use"));
	m_module = new QLabel(tr("None"));

	m_layout->addWidget(m_txt, 0, 0, 1, 2);
	m_layout->addWidget(m_module, 0, 2, 1, 2);
	m_layout->addWidget(m_buttons[LOAD_N_BUTTON], 1, 1);
	m_layout->addWidget(m_buttons[LOAD_F_BUTTON], 1, 2);
	m_layout->addWidget(m_buttons[LOAD_E_BUTTON], 1, 0);
	m_layout->addWidget(m_buttons[CLOSE_BUTTON], 1, 3);

	connect(m_buttons[LOAD_E_BUTTON], SIGNAL(pressed()),
		this, SLOT(load_g_ether()));
	connect(m_buttons[LOAD_N_BUTTON], SIGNAL(pressed()),
		this, SLOT(load_g_nokia()));
	connect(m_buttons[LOAD_F_BUTTON], SIGNAL(pressed()),
		this, SLOT(load_g_file_storage()));
	connect(m_buttons[CLOSE_BUTTON], SIGNAL(pressed()),
		this, SLOT(close()));

	connect(m_runner, SIGNAL(finished(int)),
		this, SLOT(dataAvailable(int)));

	m_conf_usb_iface = false;
	m_runner->start(script, QStringList("status"));
}

void
UsbManage::load_g_ether(void)
{
	QStringList args("g_ether");
	m_module->setText("loading...");
	m_runner->start(script, args);
	m_conf_usb_iface = true;
}

void
UsbManage::load_g_nokia(void)
{
	QStringList args("g_nokia");
	m_module->setText("loading...");
	m_runner->start(script, args);
	m_conf_usb_iface = true;
}

void
UsbManage::load_g_file_storage(void)
{
	QStringList args("g_file_storage");
	m_module->setText("loading...");
	m_runner->start(script, args);
	m_conf_usb_iface = false;
}

void
UsbManage::close(void)
{
	m_main->showLauncher();
}

void
UsbManage::dataAvailable(int exitCode)
{
	QByteArray out;
	if (exitCode != 0) {
		out = m_runner->getStderr();
		m_module->setText("None");
	} else {
		out = m_runner->getStdout();
		if (out.size() != 0) {
			m_module->setText(out.trimmed());
		}
	}
	emit done(!exitCode && m_conf_usb_iface);
}
