#!/bin/sh

# Copyright (c) 2009 Nokia Corporation. All rights reserved.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation
# files (the "Software"), to deal in the Software without
# restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following
# conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

set -eu
#exec 2>> /tmp/maddev-start.log; date >&2; set -x; : "$@"

libdir=/usr/lib/mad-developer

LC_ALL=C LANG=C
export LC_ALL LANG
PATH=/bin:/sbin:/usr/bin:/usr/sbin
export PATH

devown ()
{
	# busybox ls do not support -H, let's hope HOME is never symlink...
	# ... and busybox stat unusable.
	case `ls -ld "$1" | awk '{print $3}'` in develop*) ;;
		*) $libdir/devrootsh chown developer:developer "$1" ;;
	esac
}

test -d $HOME || $libdir/devrootsh mkdir $HOME
devown $HOME

test -f $HOME/.profile || cp $libdir/dot-profile $HOME/.profile
devown $HOME/.profile

# Share user MyDocs -- FAT32 permissions 777 on N900
test -d $HOME/MyDocs || ln -s /home/user/MyDocs $HOME/MyDocs

test -d $HOME/bin || mkdir $HOME/bin
devown $HOME/bin

test -f $HOME/bin/devrootsh || ln -s $libdir/devrootsh $HOME/bin

exec "$@"
