#ifndef _NET_INTERFACE_H_
#define _NET_INTERFACE_H_

#include <QGridLayout>
#include <QWidget>

class QString;
class QPushButton;

class MainWindow;
class ProcessRunner;

class NetInterfaces : public QWidget
{
	Q_OBJECT
public:
	NetInterfaces(MainWindow *main, ProcessRunner *runner);
	void addLine(const QString &name, const QString &ip,
		     const QString &netmask, const QString &flags);
	void clear(void);

public slots:
	void dataAvailable(int exitCode);
	void updateInterfaces(void);
	void setEditButtonEnabled(bool enabled);

private:
	QGridLayout * m_layout;
	MainWindow *m_main;
	ProcessRunner *m_runner;

	QPushButton *m_edit;
	bool m_edit_accepted;

	void mousePressEvent(QMouseEvent * event);
};
#endif
