#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation){
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
	const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
	if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
	    qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
	    return;
	}
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
	attribute = static_cast<Qt::WidgetAttribute>(128);
	break;
    case ScreenOrientationLockLandscape:
	attribute = static_cast<Qt::WidgetAttribute>(129);
	break;
    default:
    case ScreenOrientationAuto:
	attribute = static_cast<Qt::WidgetAttribute>(130);
	break;
#else // QT_VERSION < 0x040702

    case ScreenOrientationLockPortrait:
	attribute = Qt::WA_LockPortraitOrientation;
	break;
    case ScreenOrientationLockLandscape:
	attribute = Qt::WA_LockLandscapeOrientation;
	break;
    default:
    case ScreenOrientationAuto:
	attribute = Qt::WA_AutoOrientation;
	break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}


void MainWindow::on_GetKey_pressed()
{
    ui->edtKey->setText(getKey(ui->edtMac->text()));
}

QString MainWindow::getKey(QString mac){
    int a0[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    int a1[]={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
    int a2[]={0,13,10,7,5,8,15,2,10,7,0,13,15,2,5,8};
    int a3[]={0,1,3,2,7,6,4,5,15,14,12,13,8,9,11,10};
    int a4[]={0,5,11,14,7,2,12,9,15,10,4,1,8,13,3,6};
    int a5[]={0,4,8,12,0,4,8,12,0,4,8,12,0,4,8,12};
    int a6[]={0,1,3,2,6,7,5,4,12,13,15,14,10,11,9,8};
    int a7[]={0,8,0,8,1,9,1,9,2,10,2,10,3,11,3,11};
    int a8[]={0,5,11,14,6,3,13,8,12,9,7,2,10,15,1,4};
    int a9[]={0,9,2,11,5,12,7,14,10,3,8,1,15,6,13,4};
    int a10[]={0,14,13,3,11,5,6,8,6,8,11,5,13,3,0,14};
    int a11[]={0,12,8,4,1,13,9,5,2,14,10,6,3,15,11,7};
    int a12[]={0,4,9,13,2,6,11,15,4,0,13,9,6,2,15,11};
    int a13[]={0,8,1,9,3,11,2,10,6,14,7,15,5,13,4,12};
    int a14[]={0,1,3,2,7,6,4,5,14,15,13,12,9,8,10,11};
    int a15[]={0,1,3,2,6,7,5,4,13,12,14,15,11,10,8,9};
    int n1[]={0,14,10,4,8,6,2,12,0,14,10,4,8,6,2,12};
    int n2[]={0,8,0,8,3,11,3,11,6,14,6,14,5,13,5,13};
    int n3[]={0,0,3,3,2,2,1,1,4,4,7,7,6,6,5,5};
    int n4[]={0,11,12,7,15,4,3,8,14,5,2,9,1,10,13,6};
    int n5[]={0,5,1,4,6,3,7,2,12,9,13,8,10,15,11,14};
    int n6[]={0,14,4,10,11,5,15,1,6,8,2,12,13,3,9,7};
    int n7[]={0,9,0,9,5,12,5,12,10,3,10,3,15,6,15,6};
    int n8[]={0,5,11,14,2,7,9,12,12,9,7,2,14,11,5,0};
    int n9[]={0,0,0,0,4,4,4,4,0,0,0,0,4,4,4,4};
    int n10[]={0,8,1,9,3,11,2,10,5,13,4,12,6,14,7,15};
    int n11[]={0,14,13,3,9,7,4,10,6,8,11,5,15,1,2,12};
    int n12[]={0,13,10,7,4,9,14,3,10,7,0,13,14,3,4,9};
    int n13[]={0,1,3,2,6,7,5,4,15,14,12,13,9,8,10,11};
    int n14[]={0,1,3,2,4,5,7,6,12,13,15,14,8,9,11,10};
    int n15[]={0,6,12,10,9,15,5,3,2,4,14,8,11,13,7,1};
    int n16[]={0,11,6,13,13,6,11,0,11,0,13,6,6,13,0,11};
    int n17[]={0,12,8,4,1,13,9,5,3,15,11,7,2,14,10,6};
    int n18[]={0,12,9,5,2,14,11,7,5,9,12,0,7,11,14,2};
    int n19[]={0,6,13,11,10,12,7,1,5,3,8,14,15,9,2,4};
    int n20[]={0,9,3,10,7,14,4,13,14,7,13,4,9,0,10,3};
    int n21[]={0,4,8,12,1,5,9,13,2,6,10,14,3,7,11,15};
    int n22[]={0,1,2,3,5,4,7,6,11,10,9,8,14,15,12,13};
    int n23[]={0,7,15,8,14,9,1,6,12,11,3,4,2,5,13,10};
    int n24[]={0,5,10,15,4,1,14,11,8,13,2,7,12,9,6,3};
    int n25[]={0,11,6,13,13,6,11,0,10,1,12,7,7,12,1,10};
    int n26[]={0,13,10,7,4,9,14,3,8,5,2,15,12,1,6,11};
    int n27[]={0,4,9,13,2,6,11,15,5,1,12,8,7,3,14,10};
    int n28[]={0,14,12,2,8,6,4,10,0,14,12,2,8,6,4,10};
    int n29[]={0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3};
    int n30[]={0,15,14,1,12,3,2,13,8,7,6,9,4,11,10,5};
    int n31[]={0,10,4,14,9,3,13,7,2,8,6,12,11,1,15,5};
    int n32[]={0,10,5,15,11,1,14,4,6,12,3,9,13,7,8,2};
    int n33[]={0,4,9,13,3,7,10,14,7,3,14,10,4,0,13,9};
    int keys[]={30,31,32,33,34,35,36,37,38,39,61,62,63,64,65,66};
    char ssids[]={'0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f'};

    int DecMAC[12];
    QString key;
    QString ssid;
    bool ok;

    mac=mac.remove(':');

    for (int var = 0; var < 12; ++var) {
        QString hex = mac.at(var);
        uint dec = hex.toUInt(&ok,16);
        DecMAC[var]=dec;
    }

    key=key+QString::number(keys[(a2[DecMAC[0]])^(n11[DecMAC[1]])^(a7[DecMAC[2]])^(a8[DecMAC[3]])^(a14[DecMAC[4]])^(a5[DecMAC[5]])^(a5[DecMAC[6]])^(a2[DecMAC[7]])^(a0[DecMAC[8]])^(a1[DecMAC[9]])^(a15[DecMAC[10]])^(a0[DecMAC[11]])^13]);
    key=key+QString::number(keys[(n5[DecMAC[0]])^(n12[DecMAC[1]])^(a5[DecMAC[2]])^(a7[DecMAC[3]])^(a2[DecMAC[4]])^(a14[DecMAC[5]])^(a1[DecMAC[6]])^(a5[DecMAC[7]])^(a0[DecMAC[8]])^(a0[DecMAC[9]])^(n31[DecMAC[10]])^(a15[DecMAC[11]])^4]);
    key=key+QString::number(keys[(a3[DecMAC[0]])^(a5[DecMAC[1]])^(a2[DecMAC[2]])^(a10[DecMAC[3]])^(a7[DecMAC[4]])^(a8[DecMAC[5]])^(a14[DecMAC[6]])^(a5[DecMAC[7]])^(a5[DecMAC[8]])^(a2[DecMAC[9]])^(a0[DecMAC[10]])^(a1[DecMAC[11]])^7]);
    key=key+QString::number(keys[(n6[DecMAC[0]])^(n13[DecMAC[1]])^(a8[DecMAC[2]])^(a2[DecMAC[3]])^(a5[DecMAC[4]])^(a7[DecMAC[5]])^(a2[DecMAC[6]])^(a14[DecMAC[7]])^(a1[DecMAC[8]])^(a5[DecMAC[9]])^(a0[DecMAC[10]])^(a0[DecMAC[11]])^14]);
    key=key+QString::number(keys[(n7[DecMAC[0]])^(n14[DecMAC[1]])^(a3[DecMAC[2]])^(a5[DecMAC[3]])^(a2[DecMAC[4]])^(a10[DecMAC[5]])^(a7[DecMAC[6]])^(a8[DecMAC[7]])^(a14[DecMAC[8]])^(a5[DecMAC[9]])^(a5[DecMAC[10]])^(a2[DecMAC[11]])^7]);

    ssid=ssid+ssids[(n1[DecMAC[0]])^(a4[DecMAC[1]])^(a6[DecMAC[2]])^(a1[DecMAC[3]])^(a11[DecMAC[4]])^(n20[DecMAC[5]])^(a10[DecMAC[6]])^(a4[DecMAC[7]])^(a8[DecMAC[8]])^(a2[DecMAC[9]])^(a5[DecMAC[10]])^(a9[DecMAC[11]])^5];
    ssid=ssid+ssids[(n2[DecMAC[0]])^(n8[DecMAC[1]])^(n15[DecMAC[2]])^(n17[DecMAC[3]])^(a12[DecMAC[4]])^(n21[DecMAC[5]])^(n24[DecMAC[6]])^(a9[DecMAC[7]])^(n27[DecMAC[8]])^(n29[DecMAC[9]])^(a11[DecMAC[10]])^(n32[DecMAC[11]])^10];
    ssid=ssid+ssids[(n3[DecMAC[0]])^(n9[DecMAC[1]])^(a5[DecMAC[2]])^(a9[DecMAC[3]])^(n19[DecMAC[4]])^(n22[DecMAC[5]])^(a12[DecMAC[6]])^(n25[DecMAC[7]])^(a11[DecMAC[8]])^(a13[DecMAC[9]])^(n30[DecMAC[10]])^(n33[DecMAC[11]])^11];
    ssid=ssid+ssids[(n4[DecMAC[0]])^(n10[DecMAC[1]])^(n16[DecMAC[2]])^(n18[DecMAC[3]])^(a13[DecMAC[4]])^(n23[DecMAC[5]])^(a1[DecMAC[6]])^(n26[DecMAC[7]])^(n28[DecMAC[8]])^(a3[DecMAC[9]])^(a6[DecMAC[10]])^(a0[DecMAC[11]])^10];

    ui->edtSSID->setText(ssid);

    return key;
}

void MainWindow::insertChar(QString character){
    QString mac = ui->edtMac->text();
    if (mac.count()>15){
        ui->edtMac->setText(mac.insert(mac.count(),character));
    }else if (mac.count()>13){
        ui->edtMac->setText(mac.insert(mac.count()-1,character));
    }else if (mac.count()>11){
        ui->edtMac->setText(mac.insert(mac.count()-2,character));
    }else if (mac.count()>9){
        ui->edtMac->setText(mac.insert(mac.count()-3,character));
    }else if (mac.count()>7){
        ui->edtMac->setText(mac.insert(mac.count()-4,character));
    }else{
        ui->edtMac->setText(mac.insert(mac.count()-5,character));
    }
}

void MainWindow::on_btn_0_pressed()
{
     insertChar(QString('0'));
}

void MainWindow::on_btn_1_pressed()
{
     insertChar(QString('1'));
}

void MainWindow::on_btn_2_pressed()
{
     insertChar(QString('2'));
}

void MainWindow::on_btn_3_pressed()
{
     insertChar(QString('3'));
}

void MainWindow::on_btn_4_pressed()
{
     insertChar(QString('4'));
}

void MainWindow::on_btn_5_pressed()
{
     insertChar(QString('5'));
}

void MainWindow::on_btn_6_pressed()
{
     insertChar(QString('6'));
}

void MainWindow::on_btn_7_pressed()
{
     insertChar(QString('7'));
}

void MainWindow::on_btn_8_pressed()
{
     insertChar(QString('8'));
}

void MainWindow::on_btn_9_pressed()
{
     insertChar(QString('9'));
}

void MainWindow::on_btn_A_pressed()
{
     insertChar(QString('A'));
}

void MainWindow::on_btn_B_pressed()
{
     insertChar(QString('B'));
}

void MainWindow::on_btn_C_pressed()
{
   insertChar(QString('C'));
}

void MainWindow::on_btn_D_pressed()
{
     insertChar(QString('D'));
}

void MainWindow::on_btn_E_pressed()
{
    insertChar(QString('E'));
}

void MainWindow::on_btn_F_pressed()
{
    insertChar(QString('F'));
}

void MainWindow::on_btnClear_pressed()
{
    ui->edtMac->clear();
    ui->edtKey->clear();
    ui->edtSSID->clear();
}

void MainWindow::on_btnBack_pressed()
{
    if (ui->edtMac->text().count()>15){
        ui->edtMac->setText(ui->edtMac->text().left(ui->edtMac->text().count()-1));
    }else if (ui->edtMac->text().count()>13){
        ui->edtMac->setText(ui->edtMac->text().left(ui->edtMac->text().count()-2));
    }else if (ui->edtMac->text().count()>11){
        ui->edtMac->setText(ui->edtMac->text().left(ui->edtMac->text().count()-3));
    }else if (ui->edtMac->text().count()>9){
        ui->edtMac->setText(ui->edtMac->text().left(ui->edtMac->text().count()-4));
    }else if (ui->edtMac->text().count()>7){
        ui->edtMac->setText(ui->edtMac->text().left(ui->edtMac->text().count()-5));
    }else if (ui->edtMac->text().count()>5){
        ui->edtMac->setText(ui->edtMac->text().left(ui->edtMac->text().count()-6));
    }else{
        ui->edtMac->setText(ui->edtMac->text().left(ui->edtMac->text().count()-7));
    }
}
