#!/bin/ash
# customization script by Dany-69 
# icons by D4rKlar
# for info and bugs : 
# d4rklar@gmail.com 
# fenix-69@hotmail.it

if [ `id -u` != 0 ] ; then
    exec root <<EOF
exec sh $0 $*
EOF
	exit $?
fi

instpix()
{
pix=`ls /opt/usr/share/icons/D4rK/pixmaps`
	pixdir="/opt/usr/share/pixmaps"
	for image in $pix;do
		oldpix="$pixdir/$image"
		if [ -e $oldpix ]
			then
				mv $oldpix $oldpix.darkbackup
				cp /opt/usr/share/icons/D4rK/pixmaps/$image /opt/usr/share/pixmaps
		fi
	done
}

removepix()
{
back=`ls /opt/usr/share/pixmaps | grep darkbackup | awk -F"." '{ print $1; }'`
for image in $back;do
	rm /opt/usr/share/pixmaps/$image.png
	mv /opt/usr/share/pixmaps/$image.png.darkbackup /opt/usr/share/pixmaps/$image.png
done
}


instblue()
{
cond=`dpkg --list|grep -c bluezwitch`
if [ $cond -eq 1 ]
	then
		mv /home/opt/tomch.com/bluezwitch/bluezwitch.png /home/opt/tomch.com/bluezwitch/bluezwitch.png.darkbackup
		mv /home/opt/tomch.com/bluezwitch/bluezwitch-grey.png /home/opt/tomch.com/bluezwitch/bluezwitch-grey.png.darkbackup
		cp /opt/usr/share/icons/D4rK/widgets/tomch.com/bluezwitch/bluezwitch.png /home/opt/tomch.com/bluezwitch
		cp /opt/usr/share/icons/D4rK/widgets/tomch.com/bluezwitch/bluezwitch-grey.png /home/opt/tomch.com/bluezwitch
fi
}

removeblue()
{
cond=`dpkg --list|grep -c bluezwitch`
if [ $cond -eq 1 ]
	then
		back=`ls /home/opt/tomch.com/bluezwitch | grep darkbackup | awk -F"." '{ print $1; }'`
		for image in $back;do
			rm /home/opt/tomch.com/bluezwitch/$image.png
			mv /home/opt/tomch.com/bluezwitch/$image.png.darkbackup /home/opt/tomch.com/bluezwitch/$image.png
		done
fi
}

instrecaller()
{
cond=`dpkg --list|grep -c recaller`
if [ $cond -eq 1 ]
	then
		mv /home/opt/tomch.com/recaller/recaller_64.png /home/opt/tomch.com/recaller/recaller_64.png.darkbackup
		mv /home/opt/tomch.com/recaller/recaller_64_on.png /home/opt/tomch.com/recaller/recaller_64_on.png.darkbackup
		cp /opt/usr/share/icons/D4rK/widgets/tomch.com/recaller/recaller_64.png /home/opt/tomch.com/recaller
		cp /opt/usr/share/icons/D4rK/widgets/tomch.com/recaller/recaller_64_on.png /home/opt/tomch.com/recaller
fi
}

removerecaller()
{
cond=`dpkg --list|grep -c recaller`
if [ $cond -eq 1 ]
	then
		back=`ls /home/opt/tomch.com/recaller | grep darkbackup | awk -F"." '{ print $1; }'`
		for image in $back;do
			rm /home/opt/tomch.com/recaller/$image.png
			mv /home/opt/tomch.com/recaller/$image.png.darkbackup /home/opt/tomch.com/recaller/$image.png
		done
fi
}

instsys()
{
cond=`dpkg --list|grep -c systeminfowidget`
if [ $cond -eq 1 ]
	then
		mv /home/opt/systeminfowidget/bg.png /home/opt/systeminfowidget/bg.png.darkbackup
		mv /home/opt/systeminfowidget/cpu.png /home/opt/systeminfowidget/cpu.png.darkbackup
		mv /home/opt/systeminfowidget/mem.png /home/opt/systeminfowidget/mem.png.darkbackup
		cp /opt/usr/share/icons/D4rK/widgets/systeminfowidget/bg.png /home/opt/systeminfowidget
		cp /opt/usr/share/icons/D4rK/widgets/systeminfowidget/cpu.png /home/opt/systeminfowidget
		cp /opt/usr/share/icons/D4rK/widgets/systeminfowidget/mem.png /home/opt/systeminfowidget
fi
}

removesys()
{
cond=`dpkg --list|grep -c systeminfowidget`
if [ $cond -eq 1 ]
	then
		back=`ls /home/opt/systeminfowidget | grep darkbackup | awk -F"." '{ print $1; }'`
		for image in $back;do
			rm /home/opt/systeminfowidget/$image.png
			mv /home/opt/systeminfowidget/$image.png.darkbackup /home/opt/systeminfowidget/$image.png
		done
fi
}

instbattery()
{
cond="/opt/battery/batterybase.png"
if [ -e $cond ]
	then
		mv /home/opt/battery/batteryhigh.png /home/opt/battery/batteryhigh.png.darkbackup
		mv /home/opt/battery/batterylow.png /home/opt/battery/batterylow.png.darkbackup
		mv /home/opt/battery/batterymed.png /home/opt/battery/batterymed.png.darkbackup
		cp /opt/usr/share/icons/D4rK/widgets/battery/batteryhigh.png /home/opt/battery
		cp /opt/usr/share/icons/D4rK/widgets/battery/batterylow.png /home/opt/battery
		cp /opt/usr/share/icons/D4rK/widgets/battery/batterymed.png  /home/opt/battery
fi
}

removebattery()
{
cond="/opt/battery/batterybase.png"
if [ -e $cond ]
	then
		back=`ls /home/opt/battery | grep darkbackup | awk -F"." '{ print $1; }'`
		for image in $back;do
			rm /home/opt/battery/$image.png
			mv /home/opt/battery/$image.png.darkbackup /home/opt/battery/$image.png
		done
fi
}

instnameday()
{
cond=`dpkg --list|grep -c nameday-applet`
if [ $cond -eq 1 ]
	then
		mv /home/opt/maemo/usr/share/nameday/images/background.png /home/opt/maemo/usr/share/nameday/images/background.png.darkbackup
		cp /opt/usr/share/icons/D4rK/widgets/nameday/background.png /home/opt/maemo/usr/share/nameday/images
fi
}

removenameday()
{
cond=`dpkg --list|grep -c nameday-applet`
if [ $cond -eq 1 ]
	then
		back=`ls /home/opt/maemo/usr/share/nameday/images | grep darkbackup | awk -F"." '{ print $1; }'`
		for image in $back;do
			rm /home/opt/maemo/usr/share/nameday/images/$image.png
			mv /home/opt/maemo/usr/share/nameday/images/$image.png.darkbackup /home/opt/maemo/usr/share/nameday/images/$image.png
		done
fi
}

insttouch()
{
cond=`dpkg --list|grep -c touchsearch`
if [ $cond -eq 1 ]
	then
		mv /home/opt/touchsearch/icons/select_search_engine_color.png /home/opt/touchsearch/icons/select_search_engine_color.png.darkbackup
		mv /home/opt/touchsearch/icons/select_search_engine_ghosted.png /home/opt/touchsearch/icons/select_search_engine_ghosted.png.darkbackup
		mv /home/opt/touchsearch/search_engines/Google/google_color.png /home/opt/touchsearch/search_engines/Google/google_color.png.darkbackup
		mv /home/opt/touchsearch/search_engines/Google/google_ghosted.png /home/opt/touchsearch/search_engines/Google/google_ghosted.png.darkbackup
		cp /home/opt/usr/share/icons/D4rK/widgets/touchsearch/icons/select_search_engine_color.png /home/opt/touchsearch/icons
		cp /home/opt/usr/share/icons/D4rK/widgets/touchsearch/icons/select_search_engine_ghosted.png /home/opt/touchsearch/icons
		cp /home/opt/usr/share/icons/D4rK/widgets/touchsearch/search_engines/Google/google_color.png /home/opt/touchsearch/search_engines/Google
		cp /home/opt/usr/share/icons/D4rK/widgets/touchsearch/search_engines/Google/google_ghosted.png /home/opt/touchsearch/search_engines/Google
fi
}

removetouch()
{
cond=`dpkg --list|grep -c touchsearch`
if [ $cond -eq 1 ]
	then
		back=`ls /home/opt/touchsearch/icons | grep darkbackup | awk -F"." '{ print $1; }'`
		for image in $back;do
			rm /home/opt/touchsearch/icons/$image.png
			mv /home/opt/touchsearch/icons/$image.png.darkbackup /home/opt/touchsearch/icons/$image.png
		done

		back=`ls /home/opt/touchsearch/search_engines/Google | grep darkbackup | awk -F"." '{ print $1; }'`
		for image in $back;do
			rm /home/opt/touchsearch/search_engines/Google/$image.png
			mv /home/opt/touchsearch/search_engines/Google/$image.png.darkbackup /home/opt/touchsearch/search_engines/Google/$image.png
		done
fi
}

reb()
{
quest=$(zenity --warning --title="Extra D4rK" --text "For modifications to take effect, you have to reboot the device. 

Do you want to reboot now?
To abort, press anywhere outside this box.";echo $?)
if [ $quest -eq 0 ]
	then
		reboot 6
		cont=5
		while [ $cont -gt 0 ]; do
		dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Rebooting in $cont"
		let "cont = cont - 1"
		sleep 1
		done
fi
}


test=`sed -n "1p" /opt/usr/share/icons/D4rK/custom.conf`
if [ "$test" = "not_installed" ]
	then
		choice=$(zenity --warning --height 200 --title="Extra D4rK"  --text "Pressing OK will create a backup of: 
1. Pixmaps 
2. Bluezwitch widget
3. TouchSearch widget
4. SystemInfoWidget
5. Recaller
6. Battery
7. Nameday Applet
and install the Extra D4rK versions.

To abort the process, press anywhere outside this box.";echo $?)
		if [ $choice -eq 0 ]
			then
				dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Going Extra D4rK... Please wait..."
				dpkg --list |grep "^rc" | cut -d ' ' -f 3 | xargs dpkg --purge
				instpix
				instblue
				instrecaller
				instsys
				instbattery
				instnameday
				insttouch
				sed -i 1s/.*/"installed"/g /opt/usr/share/icons/D4rK/custom.conf
				dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Extra D4rK images successfully installed"
				sleep 3
				reb
		fi
	else
		choice=$(zenity --warning --height 200 --title="Extra D4rK"  --text "Pressing OK will restore the original:
1. Pixmaps 
2. Bluezwitch widget
3. TouchSearch widget
4. SystemInfoWidget
5. Recaller
6. Battery
7. Nameday Applet

To abort the process, press anywhere outside this box.";echo $?)
		if [ $choice -eq 0 ]
			then
				dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Restoring default images. Please wait.."
				removepix
				removeblue
				removerecaller
				removesys
				removebattery
				removenameday
				removetouch
				sed -i 1s/.*/"not_installed"/g /opt/usr/share/icons/D4rK/custom.conf
				dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Boring images successfully restored... (yawn)"
				sleep 3
				reb
		fi
fi




