/* tiltstick.h - header file for the maemo tiltstick interface
 *
 * libtiltstick version 1.0
 * Copyright (c) 2008 Till Harbaum
 */

#ifndef TILTSTICK_H
#define TILTSTICK_H

/* currently at most 3 axes are supported */
#define TILTSTICK_MAX_AXIS  3

#define TILTSTICK_BUTTON_0  (1<<0)
#define TILTSTICK_BUTTON_1  (1<<1)

/* Inhibit C++ name-mangling */
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  
  int tiltstick_evif_open(void);
  int tiltstick_evif_poll(int *axis, int *axis_num, int *buttons);
  char *tiltstick_get_name(void);
  int tiltstick_get_axes(void);

#ifdef __cplusplus
}
#endif

#endif // TILTSTICK_H
